/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;

public class OllamaLanguageModel
implements LanguageModel {
    private final OllamaClient client;
    private final String modelName;
    private final Double temperature;
    private final Integer maxRetries;

    public OllamaLanguageModel(String baseUrl, Duration timeout, String modelName, Double temperature, Integer maxRetries) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout(timeout).build();
        this.modelName = modelName;
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).options(Options.builder().temperature(this.temperature).build()).stream(false).build();
        CompletionResponse response = (CompletionResponse)RetryUtils.withRetry(() -> this.client.completion(request), (int)this.maxRetries);
        return Response.from((Object)response.getResponse(), (TokenUsage)new TokenUsage(response.getPromptEvalCount(), response.getEvalCount()));
    }

    public static OllamaLanguageModelBuilder builder() {
        return new OllamaLanguageModelBuilder();
    }

    public static class OllamaLanguageModelBuilder {
        private String baseUrl;
        private Duration timeout;
        private String modelName;
        private Double temperature;
        private Integer maxRetries;

        OllamaLanguageModelBuilder() {
        }

        public OllamaLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaLanguageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaLanguageModel build() {
            return new OllamaLanguageModel(this.baseUrl, this.timeout, this.modelName, this.temperature, this.maxRetries);
        }

        public String toString() {
            return "OllamaLanguageModel.OllamaLanguageModelBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

