/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.nomic;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.nomic.EmbeddingRequest;
import dev.langchain4j.model.nomic.EmbeddingResponse;
import dev.langchain4j.model.nomic.NomicClient;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class NomicEmbeddingModel
implements EmbeddingModel {
    private static final String DEFAULT_BASE_URL = "https://api-atlas.nomic.ai/v1/";
    private final NomicClient client;
    private final String modelName;
    private final String taskType;
    private final Integer maxRetries;

    public NomicEmbeddingModel(String baseUrl, String apiKey, String modelName, String taskType, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.client = NomicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).apiKey(ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey")).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"nomic-embed-text-v1");
        this.taskType = taskType;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static NomicEmbeddingModel withApiKey(String apiKey) {
        return NomicEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        EmbeddingRequest request = EmbeddingRequest.builder().model(this.modelName).texts(textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).taskType(this.taskType).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> this.client.embed(request), (int)this.maxRetries);
        List embeddings = response.getEmbeddings().stream().map(Embedding::from).collect(Collectors.toList());
        TokenUsage tokenUsage = new TokenUsage(response.getUsage().getTotalTokens(), Integer.valueOf(0));
        return Response.from(embeddings, (TokenUsage)tokenUsage);
    }

    public static NomicEmbeddingModelBuilder builder() {
        return new NomicEmbeddingModelBuilder();
    }

    public static class NomicEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private String taskType;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        NomicEmbeddingModelBuilder() {
        }

        public NomicEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public NomicEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public NomicEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public NomicEmbeddingModelBuilder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public NomicEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public NomicEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public NomicEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public NomicEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public NomicEmbeddingModel build() {
            return new NomicEmbeddingModel(this.baseUrl, this.apiKey, this.modelName, this.taskType, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "NomicEmbeddingModel.NomicEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", taskType=" + this.taskType + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

