/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.mistralai.MistralAiClient;
import dev.langchain4j.model.mistralai.MistralAiModelCard;
import dev.langchain4j.model.mistralai.MistralAiModelResponse;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.List;

public class MistralAiModels {
    private final MistralAiClient client;
    private final Integer maxRetries;

    public MistralAiModels(String baseUrl, String apiKey, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries) {
        this.client = MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1")).apiKey(apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static MistralAiModels withApiKey(String apiKey) {
        return MistralAiModels.builder().apiKey(apiKey).build();
    }

    public Response<List<MistralAiModelCard>> availableModels() {
        MistralAiModelResponse response = (MistralAiModelResponse)RetryUtils.withRetry(this.client::listModels, (int)this.maxRetries);
        return Response.from(response.getData());
    }

    public static MistralAiModelsBuilder builder() {
        return new MistralAiModelsBuilder();
    }

    public static class MistralAiModelsBuilder {
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;

        MistralAiModelsBuilder() {
        }

        public MistralAiModelsBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiModelsBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiModelsBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiModelsBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiModelsBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiModelsBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiModels build() {
            return new MistralAiModels(this.baseUrl, this.apiKey, this.timeout, this.logRequests, this.logResponses, this.maxRetries);
        }

        public String toString() {
            return "MistralAiModels.MistralAiModelsBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

