/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import dev.langchain4j.model.mistralai.MistralAiClient;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModelName;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingResponse;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class MistralAiEmbeddingModel
implements EmbeddingModel {
    private final MistralAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public MistralAiEmbeddingModel(String baseUrl, String apiKey, String modelName, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries) {
        this.client = MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1")).apiKey(apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)MistralAiEmbeddingModelName.MISTRAL_EMBED.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static MistralAiEmbeddingModel withApiKey(String apiKey) {
        return MistralAiEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        MistralAiEmbeddingRequest request = MistralAiEmbeddingRequest.builder().model(this.modelName).input(textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).encodingFormat("float").build();
        MistralAiEmbeddingResponse response = (MistralAiEmbeddingResponse)RetryUtils.withRetry(() -> this.client.embedding(request), (int)this.maxRetries);
        List embeddings = response.getData().stream().map(mistralAiEmbedding -> Embedding.from(mistralAiEmbedding.getEmbedding())).collect(Collectors.toList());
        return Response.from(embeddings, (TokenUsage)DefaultMistralAiHelper.tokenUsageFrom(response.getUsage()));
    }

    public static MistralAiEmbeddingModelBuilder builder() {
        return new MistralAiEmbeddingModelBuilder();
    }

    public static class MistralAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;

        MistralAiEmbeddingModelBuilder() {
        }

        public MistralAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiEmbeddingModel build() {
            return new MistralAiEmbeddingModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.logRequests, this.logResponses, this.maxRetries);
        }

        public String toString() {
            return "MistralAiEmbeddingModel.MistralAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

