/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.RelevanceScore;
import dev.langchain4j.store.embedding.milvus.CollectionOperationsExecutor;
import dev.langchain4j.store.embedding.milvus.Generator;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class Mapper {
    Mapper() {
    }

    static List<List<Float>> toVectors(List<Embedding> embeddings) {
        return embeddings.stream().map(Embedding::vectorAsList).collect(Collectors.toList());
    }

    static List<String> toScalars(List<TextSegment> textSegments, int size) {
        boolean noScalars = textSegments == null || textSegments.isEmpty();
        return noScalars ? Generator.generateEmptyScalars(size) : Mapper.textSegmentsToScalars(textSegments);
    }

    static List<String> textSegmentsToScalars(List<TextSegment> textSegments) {
        return textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
    }

    static List<EmbeddingMatch<TextSegment>> toEmbeddingMatches(MilvusServiceClient milvusClient, SearchResultsWrapper resultsWrapper, String collectionName, ConsistencyLevelEnum consistencyLevel, boolean queryForVectorOnSearch) {
        ArrayList<EmbeddingMatch<TextSegment>> matches = new ArrayList<EmbeddingMatch<TextSegment>>();
        HashMap<String, Embedding> idToEmbedding = new HashMap<String, Embedding>();
        if (queryForVectorOnSearch) {
            try {
                List rowIds = resultsWrapper.getFieldWrapper("id").getFieldData();
                idToEmbedding.putAll(Mapper.queryEmbeddings(milvusClient, collectionName, rowIds, consistencyLevel));
            }
            catch (ParamException rowIds) {
                // empty catch block
            }
        }
        for (int i = 0; i < resultsWrapper.getRowRecords().size(); ++i) {
            double score = ((SearchResultsWrapper.IDScore)resultsWrapper.getIDScore(0).get(i)).getScore();
            String rowId = ((SearchResultsWrapper.IDScore)resultsWrapper.getIDScore(0).get(i)).getStrID();
            Embedding embedding = (Embedding)idToEmbedding.get(rowId);
            String text = String.valueOf(resultsWrapper.getFieldData("text", 0).get(i));
            TextSegment textSegment = Utils.isNullOrBlank((String)text) ? null : TextSegment.from((String)text);
            EmbeddingMatch embeddingMatch = new EmbeddingMatch(Double.valueOf(RelevanceScore.fromCosineSimilarity((double)score)), rowId, embedding, (Object)textSegment);
            matches.add((EmbeddingMatch<TextSegment>)embeddingMatch);
        }
        return matches;
    }

    private static Map<String, Embedding> queryEmbeddings(MilvusServiceClient milvusClient, String collectionName, List<String> rowIds, ConsistencyLevelEnum consistencyLevel) {
        QueryResultsWrapper queryResultsWrapper = CollectionOperationsExecutor.queryForVectors(milvusClient, collectionName, rowIds, consistencyLevel);
        HashMap<String, Embedding> idToEmbedding = new HashMap<String, Embedding>();
        for (QueryResultsWrapper.RowRecord row : queryResultsWrapper.getRowRecords()) {
            String id = row.get("id").toString();
            List vector = (List)row.get("vector");
            idToEmbedding.put(id, Embedding.from((List)vector));
        }
        return idToEmbedding;
    }
}

