/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.CollectionOperationsExecutor;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.Generator;
import dev.langchain4j.store.embedding.milvus.MilvusCollectionDescription;
import dev.langchain4j.store.embedding.milvus.MilvusOperationsParams;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.MetricType;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class Mapper {
    Mapper() {
    }

    public static List<List<Float>> toVectors(List<Embedding> embeddings) {
        return embeddings.stream().map(Embedding::vectorAsList).collect(Collectors.toList());
    }

    public static List<String> toScalars(List<TextSegment> textSegments, int size) {
        boolean noScalars = textSegments == null || textSegments.isEmpty();
        return noScalars ? Generator.generateEmptyScalars(size) : Mapper.textSegmentsToScalars(textSegments);
    }

    public static List<String> textSegmentsToScalars(List<TextSegment> textSegments) {
        return textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
    }

    public static List<EmbeddingMatch<TextSegment>> toEmbeddingMatches(MilvusServiceClient milvusClient, SearchResultsWrapper resultsWrapper, MilvusCollectionDescription collectionDescription, MilvusOperationsParams operationsParams, double minSimilarity) {
        ArrayList<EmbeddingMatch<TextSegment>> result = new ArrayList<EmbeddingMatch<TextSegment>>();
        List rowIds = resultsWrapper.getFieldWrapper(collectionDescription.idFieldName()).getFieldData();
        Map<String, List<Float>> idsAndVectors = Mapper.getVectors(milvusClient, collectionDescription, rowIds, operationsParams);
        for (int i = 0; i < resultsWrapper.getRowRecords().size(); ++i) {
            String rowId = ((SearchResultsWrapper.IDScore)resultsWrapper.getIDScore(0).get(i)).getStrID();
            double score = ((SearchResultsWrapper.IDScore)resultsWrapper.getIDScore(0).get(i)).getScore();
            String text = String.valueOf(resultsWrapper.getFieldData(collectionDescription.scalarFieldName(), 0).get(i));
            Embedding embedding = Embedding.from(idsAndVectors.getOrDefault(rowId, Collections.emptyList()));
            TextSegment textSegment = new TextSegment(text, null);
            EmbeddingMatch embeddingMatch = new EmbeddingMatch(Double.valueOf(score), rowId, embedding, (Object)textSegment);
            result.add((EmbeddingMatch<TextSegment>)embeddingMatch);
        }
        return Mapper.filterByMinSimilarity(result, minSimilarity, operationsParams.metricType().name());
    }

    private static List<EmbeddingMatch<TextSegment>> filterByMinSimilarity(List<EmbeddingMatch<TextSegment>> matches, double minSimilarity, String metricType) {
        Predicate<EmbeddingMatch<TextSegment>> predicate = Mapper.getPredicate(metricType, minSimilarity);
        return matches.stream().filter(predicate).collect(Collectors.toList());
    }

    private static Predicate<EmbeddingMatch<TextSegment>> getPredicate(String metricType, double minSimilarity) {
        Predicate<EmbeddingMatch<TextSegment>> l2Predicate = em -> em.score() <= minSimilarity;
        Predicate<EmbeddingMatch<TextSegment>> ipPredicate = em -> em.score() >= minSimilarity;
        if (MetricType.L2.equals((Object)MetricType.valueOf((String)metricType))) {
            return l2Predicate;
        }
        if (MetricType.IP.equals((Object)MetricType.valueOf((String)metricType))) {
            return ipPredicate;
        }
        throw new IllegalArgumentException(String.format("Unsupported metricType: '%s'.%n", metricType));
    }

    private static Map<String, List<Float>> getVectors(MilvusServiceClient milvusClient, MilvusCollectionDescription collectionDescription, List<String> rowIds, MilvusOperationsParams operationsParams) {
        if (operationsParams.queryForVectorOnSearch()) {
            QueryResultsWrapper queryResultsWrapper = CollectionOperationsExecutor.queryForVectors(milvusClient, collectionDescription, rowIds, operationsParams.consistencyLevel().name());
            HashMap<String, List<Float>> idsAndVectors = new HashMap<String, List<Float>>();
            for (QueryResultsWrapper.RowRecord row : queryResultsWrapper.getRowRecords()) {
                String id = row.get(collectionDescription.idFieldName()).toString();
                List vector = (List)row.get(collectionDescription.vectorFieldName());
                idsAndVectors.put(id, vector);
            }
            return idsAndVectors;
        }
        return Collections.emptyMap();
    }
}

