/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import dev.langchain4j.exception.ToolArgumentsException;
import dev.langchain4j.exception.ToolExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ToolExecutionHelper {
    private static final int ERROR_CODE_INVALID_PARAMETERS = -32602;

    ToolExecutionHelper() {
    }

    static String extractResult(JsonNode result) {
        if (result.has("result")) {
            JsonNode resultNode = result.get("result");
            if (resultNode.has("content")) {
                String content = ToolExecutionHelper.extractSuccessfulResult((ArrayNode)resultNode.get("content"));
                if (ToolExecutionHelper.isError(resultNode)) {
                    throw new ToolExecutionException(content);
                }
                return content;
            }
            throw new RuntimeException("Result does not contain 'content' element: " + String.valueOf(result));
        }
        if (result.has("error")) {
            String errorMessage = ToolExecutionHelper.extractErrorMessage(result.get("error"));
            Integer errorCode = ToolExecutionHelper.extractErrorCode(result.get("error"));
            if (errorCode != null && errorCode == -32602) {
                throw new ToolArgumentsException(errorMessage, errorCode);
            }
            throw new ToolExecutionException(errorMessage, errorCode);
        }
        throw new RuntimeException("Result contains neither 'result' nor 'error' element: " + String.valueOf(result));
    }

    private static String extractSuccessfulResult(ArrayNode contents) {
        Stream<JsonNode> contentStream = StreamSupport.stream(contents.spliterator(), false);
        return contentStream.map(content -> {
            if (!content.get("type").asText().equals("text")) {
                throw new RuntimeException("Unsupported content type: " + String.valueOf(content.get("type")));
            }
            return content.get("text").asText();
        }).collect(Collectors.joining("\n"));
    }

    private static boolean isError(JsonNode resultNode) {
        if (resultNode.has("isError")) {
            return resultNode.get("isError").asBoolean();
        }
        return false;
    }

    private static String extractErrorMessage(JsonNode errorNode) {
        if (errorNode.has("message")) {
            return errorNode.get("message").asText("");
        }
        return "";
    }

    private static Integer extractErrorCode(JsonNode errorNode) {
        if (errorNode.has("code")) {
            return errorNode.get("code").asInt();
        }
        return null;
    }
}

