/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpToolProvider
implements ToolProvider {
    private final List<McpClient> mcpClients;
    private final boolean failIfOneServerFails;
    private static final Logger log = LoggerFactory.getLogger(McpToolProvider.class);

    private McpToolProvider(Builder builder) {
        this.mcpClients = new ArrayList<McpClient>(builder.mcpClients);
        this.failIfOneServerFails = (Boolean)Utils.getOrDefault((Object)builder.failIfOneServerFails, (Object)false);
    }

    public ToolProviderResult provideTools(ToolProviderRequest request) {
        ToolProviderResult.Builder builder = ToolProviderResult.builder();
        for (McpClient mcpClient : this.mcpClients) {
            try {
                List<ToolSpecification> toolSpecifications = mcpClient.listTools();
                for (ToolSpecification toolSpecification : toolSpecifications) {
                    builder.add(toolSpecification, (executionRequest, memoryId) -> mcpClient.executeTool(executionRequest));
                }
            }
            catch (Exception e) {
                if (this.failIfOneServerFails) {
                    throw new RuntimeException("Failed to retrieve tools from MCP server", e);
                }
                log.warn("Failed to retrieve tools from MCP server", (Throwable)e);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<McpClient> mcpClients;
        private Boolean failIfOneServerFails;

        public Builder mcpClients(List<McpClient> mcpClients) {
            this.mcpClients = mcpClients;
            return this;
        }

        public Builder mcpClients(McpClient ... mcpClients) {
            this.mcpClients = Arrays.asList(mcpClients);
            return this;
        }

        public Builder failIfOneServerFails(boolean failIfOneServerFails) {
            this.failIfOneServerFails = failIfOneServerFails;
            return this;
        }

        public McpToolProvider build() {
            return new McpToolProvider(this);
        }
    }
}

