/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.mariadb;

import dev.langchain4j.store.embedding.mariadb.MetadataStorageConfig;
import dev.langchain4j.store.embedding.mariadb.MetadataStorageMode;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public record DefaultMetadataStorageConfig(MetadataStorageMode storageMode, List<String> columnDefinitions, List<String> indexes) implements MetadataStorageConfig
{
    public static MetadataStorageConfig defaultConfig() {
        return DefaultMetadataStorageConfig.builder().storageMode(MetadataStorageMode.COMBINED_JSON).columnDefinitions(Collections.singletonList("metadata JSON NULL")).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MetadataStorageMode storageMode;
        private List<String> columnDefinitions;
        private List<String> indexes;

        public @NonNull Builder storageMode(@NonNull MetadataStorageMode storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        public @NonNull Builder columnDefinitions(@NonNull List<String> columnDefinitions) {
            this.columnDefinitions = columnDefinitions;
            return this;
        }

        public @NonNull Builder indexes(@NonNull List<String> indexes) {
            this.indexes = indexes;
            return this;
        }

        public @NonNull DefaultMetadataStorageConfig build() {
            return new DefaultMetadataStorageConfig(this.storageMode, this.columnDefinitions, this.indexes);
        }
    }
}

