/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jina.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.jina.internal.api.JinaApi;
import dev.langchain4j.model.jina.internal.api.JinaEmbeddingRequest;
import dev.langchain4j.model.jina.internal.api.JinaEmbeddingResponse;
import dev.langchain4j.model.jina.internal.api.JinaRerankingRequest;
import dev.langchain4j.model.jina.internal.api.JinaRerankingResponse;
import dev.langchain4j.model.jina.internal.client.RequestLoggingInterceptor;
import dev.langchain4j.model.jina.internal.client.ResponseLoggingInterceptor;
import java.io.IOException;
import java.time.Duration;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class JinaClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final JinaApi jinaApi;
    private final String authorizationHeader;

    JinaClient(String baseUrl, String apiKey, Duration timeout, boolean logRequests, boolean logResponses) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.jinaApi = (JinaApi)retrofit.create(JinaApi.class);
        this.authorizationHeader = "Bearer " + ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
    }

    public JinaEmbeddingResponse embed(JinaEmbeddingRequest request) {
        try {
            Response retrofitResponse = this.jinaApi.embed(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return (JinaEmbeddingResponse)retrofitResponse.body();
            }
            throw JinaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JinaRerankingResponse rerank(JinaRerankingRequest request) {
        try {
            Response retrofitResponse = this.jinaApi.rerank(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return (JinaRerankingResponse)retrofitResponse.body();
            }
            throw JinaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    @Generated
    public static JinaClientBuilder builder() {
        return new JinaClientBuilder();
    }

    @Generated
    public static class JinaClientBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;
        @Generated
        private Duration timeout;
        @Generated
        private boolean logRequests;
        @Generated
        private boolean logResponses;

        @Generated
        JinaClientBuilder() {
        }

        @Generated
        public JinaClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public JinaClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public JinaClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public JinaClientBuilder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public JinaClientBuilder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public JinaClient build() {
            return new JinaClient(this.baseUrl, this.apiKey, this.timeout, this.logRequests, this.logResponses);
        }

        @Generated
        public String toString() {
            return "JinaClient.JinaClientBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + String.valueOf(this.timeout) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

