/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jina;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.jina.internal.api.JinaRerankingRequest;
import dev.langchain4j.model.jina.internal.api.JinaRerankingResponse;
import dev.langchain4j.model.jina.internal.client.JinaClient;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.scoring.ScoringModel;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class JinaScoringModel
implements ScoringModel {
    private static final String DEFAULT_BASE_URL = "https://api.jina.ai/v1/";
    private final JinaClient client;
    private final String modelName;
    private final Integer maxRetries;

    public JinaScoringModel(String baseUrl, String apiKey, String modelName, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.client = JinaClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).apiKey(ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey")).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<List<Double>> scoreAll(List<TextSegment> segments, String query) {
        JinaRerankingRequest request = JinaRerankingRequest.builder().model(this.modelName).query(query).documents(segments.stream().map(TextSegment::text).collect(Collectors.toList())).returnDocuments(false).build();
        JinaRerankingResponse response = (JinaRerankingResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.rerank(request), (int)this.maxRetries);
        List scores = response.results.stream().sorted(Comparator.comparingInt(result -> result.index)).map(result -> result.relevanceScore).collect(Collectors.toList());
        TokenUsage tokenUsage = new TokenUsage(response.usage.promptTokens, Integer.valueOf(0), response.usage.totalTokens);
        return Response.from(scores, (TokenUsage)tokenUsage);
    }

    @Generated
    public static JinaScoringModelBuilder builder() {
        return new JinaScoringModelBuilder();
    }

    @Generated
    public static class JinaScoringModelBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;
        @Generated
        private String modelName;
        @Generated
        private Duration timeout;
        @Generated
        private Integer maxRetries;
        @Generated
        private Boolean logRequests;
        @Generated
        private Boolean logResponses;

        @Generated
        JinaScoringModelBuilder() {
        }

        @Generated
        public JinaScoringModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public JinaScoringModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public JinaScoringModel build() {
            return new JinaScoringModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        @Generated
        public String toString() {
            return "JinaScoringModel.JinaScoringModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

