/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jina;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.jina.internal.api.JinaEmbeddingRequest;
import dev.langchain4j.model.jina.internal.api.JinaEmbeddingResponse;
import dev.langchain4j.model.jina.internal.client.JinaClient;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class JinaEmbeddingModel
extends DimensionAwareEmbeddingModel {
    private static final String DEFAULT_BASE_URL = "https://api.jina.ai/";
    private final JinaClient client;
    private final String modelName;
    private final Integer maxRetries;
    private final Boolean lateChunking;

    public JinaEmbeddingModel(String baseUrl, String apiKey, String modelName, Duration timeout, Integer maxRetries, Boolean lateChunking, Boolean logRequests, Boolean logResponses) {
        this.client = JinaClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).apiKey(apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.lateChunking = (Boolean)Utils.getOrDefault((Object)lateChunking, (Object)false);
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        JinaEmbeddingRequest request = JinaEmbeddingRequest.builder().model(this.modelName).lateChunking(this.lateChunking).input(textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        JinaEmbeddingResponse response = (JinaEmbeddingResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.embed(request), (int)this.maxRetries);
        List embeddings = response.data.stream().map(jinaEmbedding -> Embedding.from((float[])jinaEmbedding.embedding)).collect(Collectors.toList());
        TokenUsage tokenUsage = new TokenUsage(response.usage.promptTokens, Integer.valueOf(0), response.usage.totalTokens);
        return Response.from(embeddings, (TokenUsage)tokenUsage);
    }

    @Generated
    public static JinaEmbeddingModelBuilder builder() {
        return new JinaEmbeddingModelBuilder();
    }

    @Generated
    public static class JinaEmbeddingModelBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;
        @Generated
        private String modelName;
        @Generated
        private Duration timeout;
        @Generated
        private Integer maxRetries;
        @Generated
        private Boolean lateChunking;
        @Generated
        private Boolean logRequests;
        @Generated
        private Boolean logResponses;

        @Generated
        JinaEmbeddingModelBuilder() {
        }

        @Generated
        public JinaEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder lateChunking(Boolean lateChunking) {
            this.lateChunking = lateChunking;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public JinaEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public JinaEmbeddingModel build() {
            return new JinaEmbeddingModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.maxRetries, this.lateChunking, this.logRequests, this.logResponses);
        }

        @Generated
        public String toString() {
            return "JinaEmbeddingModel.JinaEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ", lateChunking=" + this.lateChunking + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

