/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.spring.restclient;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.spring.restclient.SpringRestClientBuilder;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventListenerUtils;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.Utils;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientResponseException;

public class SpringRestClient
implements HttpClient {
    private final RestClient delegate;
    private final AsyncTaskExecutor streamingRequestExecutor;

    public SpringRestClient(SpringRestClientBuilder builder) {
        RestClient.Builder restClientBuilder = (RestClient.Builder)Utils.getOrDefault((Object)builder.restClientBuilder(), RestClient::builder);
        ClientHttpRequestFactorySettings settings = ClientHttpRequestFactorySettings.DEFAULTS;
        if (builder.connectTimeout() != null) {
            settings = settings.withConnectTimeout(builder.connectTimeout());
        }
        if (builder.readTimeout() != null) {
            settings = settings.withReadTimeout(builder.readTimeout());
        }
        ClientHttpRequestFactory clientHttpRequestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)settings);
        this.delegate = restClientBuilder.requestFactory(clientHttpRequestFactory).build();
        this.streamingRequestExecutor = (AsyncTaskExecutor)Utils.getOrDefault((Object)builder.streamingRequestExecutor(), () -> {
            if (builder.createDefaultStreamingRequestExecutor().booleanValue()) {
                return SpringRestClient.createDefaultStreamingRequestExecutor();
            }
            return null;
        });
    }

    private static AsyncTaskExecutor createDefaultStreamingRequestExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setQueueCapacity(0);
        taskExecutor.initialize();
        return taskExecutor;
    }

    public static SpringRestClientBuilder builder() {
        return new SpringRestClientBuilder();
    }

    public SuccessfulHttpResponse execute(HttpRequest request) throws HttpException {
        try {
            ResponseEntity responseEntity = this.toSpringRestClientRequest(request).retrieve().toEntity(String.class);
            return SuccessfulHttpResponse.builder().statusCode(responseEntity.getStatusCode().value()).headers((Map)responseEntity.getHeaders()).body((String)responseEntity.getBody()).build();
        }
        catch (RestClientResponseException e) {
            throw new HttpException(e.getStatusCode().value(), e.getMessage());
        }
        catch (Exception e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException((Throwable)e);
            }
            throw e;
        }
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
        this.streamingRequestExecutor.execute(() -> {
            try {
                this.toSpringRestClientRequest(request).exchange((springRequest, springResponse) -> {
                    int statusCode = springResponse.getStatusCode().value();
                    if (!springResponse.getStatusCode().is2xxSuccessful()) {
                        String body = (String)springResponse.bodyTo(String.class);
                        HttpException exception = new HttpException(statusCode, body);
                        ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)exception));
                        return null;
                    }
                    SuccessfulHttpResponse response = SuccessfulHttpResponse.builder().statusCode(statusCode).headers((Map)springResponse.getHeaders()).build();
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onOpen(response));
                    try (InputStream inputStream = springResponse.getBody();){
                        parser.parse(inputStream, listener);
                        ServerSentEventListenerUtils.ignoringExceptions(() -> ((ServerSentEventListener)listener).onClose());
                    }
                    return null;
                });
            }
            catch (Exception e) {
                if (e.getCause() instanceof SocketTimeoutException) {
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)new TimeoutException((Throwable)e)));
                }
                ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)e));
            }
        });
    }

    private RestClient.RequestBodySpec toSpringRestClientRequest(HttpRequest request) {
        RestClient.RequestBodySpec requestBodySpec = (RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.delegate.method(HttpMethod.valueOf((String)request.method().name())).uri(request.url(), new Object[0])).headers(httpHeaders -> httpHeaders.putAll(request.headers()));
        if (request.body() != null) {
            requestBodySpec.body((Object)request.body());
        }
        return requestBodySpec;
    }
}

