/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.googleai.BatchRequestResponse;
import dev.langchain4j.model.googleai.GeminiFiles;
import dev.langchain4j.model.googleai.GeminiService;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Experimental
final class GeminiBatchProcessor<REQUEST, RESPONSE, API_REQUEST, API_RESPONSE> {
    private final GeminiService geminiService;
    private final RequestPreparer<REQUEST, API_REQUEST, API_RESPONSE, RESPONSE> preparer;

    GeminiBatchProcessor(GeminiService geminiService, RequestPreparer<REQUEST, API_REQUEST, API_RESPONSE, RESPONSE> preparer) {
        this.geminiService = geminiService;
        this.preparer = preparer;
    }

    BatchRequestResponse.BatchResponse<RESPONSE> createBatchInline(String displayName, @Nullable Long priority, List<REQUEST> requests, String modelName, GeminiService.BatchOperationType operationType) {
        List inlineRequests = requests.stream().map(this.preparer::prepareRequest).map(this.preparer::createInlinedRequest).map(request -> new BatchRequestResponse.BatchCreateRequest.InlinedRequest<Object>(request, Map.of())).toList();
        BatchRequestResponse.BatchCreateRequest request2 = new BatchRequestResponse.BatchCreateRequest(new BatchRequestResponse.BatchCreateRequest.Batch(displayName, new BatchRequestResponse.BatchCreateRequest.InputConfig(new BatchRequestResponse.BatchCreateRequest.Requests(inlineRequests)), (Long)Utils.getOrDefault((Object)priority, (Object)0L)));
        return this.processResponse(this.geminiService.batchCreate(modelName, request2, operationType), this.preparer);
    }

    BatchRequestResponse.BatchResponse<RESPONSE> createBatchFromFile(String displayName, GeminiFiles.GeminiFile file, String modelName, GeminiService.BatchOperationType operationType) {
        return this.processResponse(this.geminiService.batchCreate(modelName, new BatchRequestResponse.BatchCreateFileRequest(new BatchRequestResponse.BatchCreateFileRequest.FileBatch(displayName, new BatchRequestResponse.BatchCreateFileRequest.FileInputConfig(file.name()))), operationType), this.preparer);
    }

    BatchRequestResponse.BatchResponse<RESPONSE> retrieveBatchResults(BatchRequestResponse.BatchName name) {
        BatchRequestResponse.Operation operation = this.geminiService.batchRetrieveBatch(name.value());
        return this.processResponse(operation, this.preparer);
    }

    void cancelBatchJob(BatchRequestResponse.BatchName name) {
        this.geminiService.batchCancelBatch(name.value());
    }

    void deleteBatchJob(BatchRequestResponse.BatchName name) {
        this.geminiService.batchDeleteBatch(name.value());
    }

    BatchRequestResponse.BatchList<RESPONSE> listBatchJobs(@Nullable Integer pageSize, @Nullable String pageToken) {
        BatchRequestResponse.ListOperationsResponse response = this.geminiService.batchListBatches(pageSize, pageToken);
        return new BatchRequestResponse.BatchList(response.nextPageToken(), response.operations().stream().map(operation -> this.processResponse((BatchRequestResponse.Operation<API_RESPONSE>)operation, this.preparer)).toList());
    }

    private BatchRequestResponse.BatchResponse<RESPONSE> processResponse(BatchRequestResponse.Operation<API_RESPONSE> operation, RequestPreparer<REQUEST, API_REQUEST, API_RESPONSE, RESPONSE> preparer) {
        if (operation.done()) {
            if (operation.error() != null) {
                return new BatchRequestResponse.BatchError(new BatchRequestResponse.BatchName(operation.name()), operation.error().code(), operation.error().message(), this.extractBatchState(operation.metadata()), operation.error().details());
            }
            return new BatchRequestResponse.BatchSuccess<RESPONSE>(new BatchRequestResponse.BatchName(operation.name()), preparer.extractResponses(operation.response()));
        }
        return new BatchRequestResponse.BatchIncomplete(new BatchRequestResponse.BatchName(operation.name()), this.extractBatchState(operation.metadata()));
    }

    private BatchRequestResponse.BatchJobState extractBatchState(Map<String, Object> metadata) {
        if (metadata == null) {
            return BatchRequestResponse.BatchJobState.UNSPECIFIED;
        }
        Object stateObj = metadata.get("state");
        if (stateObj == null) {
            return BatchRequestResponse.BatchJobState.UNSPECIFIED;
        }
        try {
            return BatchRequestResponse.BatchJobState.valueOf(stateObj.toString());
        }
        catch (IllegalArgumentException e) {
            return BatchRequestResponse.BatchJobState.UNSPECIFIED;
        }
    }

    static interface RequestPreparer<REQUEST, API_REQUEST, API_RESPONSE, RESPONSE> {
        public REQUEST prepareRequest(REQUEST var1);

        public API_REQUEST createInlinedRequest(REQUEST var1);

        public List<RESPONSE> extractResponses(BatchRequestResponse.BatchCreateResponse<API_RESPONSE> var1);
    }
}

