/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.CustomMimeTypesFileTypeDetector;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.Json;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class PartsAndContentsMapper {
    static final String THINKING_SIGNATURE_KEY = "thinking_signature";
    static final String GENERATED_IMAGES_KEY = "generated_images";
    private static final CustomMimeTypesFileTypeDetector mimeTypeDetector = new CustomMimeTypesFileTypeDetector();
    private static final Pattern DATA_URI_PATTERN = Pattern.compile("^data:([^;,]+)(?:;[^,]*)?,(.*)$");

    private PartsAndContentsMapper() {
    }

    static GeminiContent.GeminiPart fromContentToGPart(Content content) {
        if (content instanceof TextContent) {
            TextContent textContent = (TextContent)content;
            return GeminiContent.GeminiPart.builder().text(textContent.text()).build();
        }
        if (content instanceof ImageContent) {
            ImageContent imageContent = (ImageContent)content;
            Image image = imageContent.image();
            if (!Utils.isNullOrBlank((String)image.base64Data())) {
                return GeminiContent.GeminiPart.builder().inlineData(new GeminiContent.GeminiPart.GeminiBlob(image.mimeType(), image.base64Data())).build();
            }
            if (image.url() != null) {
                URI url = image.url();
                if (url.getScheme() != null && url.getScheme().equals("data")) {
                    return GeminiContent.GeminiPart.builder().inlineData(PartsAndContentsMapper.parseDataUri(url)).build();
                }
                if (url.getScheme() != null && url.getScheme().startsWith("http")) {
                    byte[] imageBytes = Utils.readBytes((String)url.toString());
                    String base64Data = Base64.getEncoder().encodeToString(imageBytes);
                    return GeminiContent.GeminiPart.builder().inlineData(new GeminiContent.GeminiPart.GeminiBlob((String)Utils.getOrDefault((Object)image.mimeType(), (Object)mimeTypeDetector.probeContentType(url)), base64Data)).build();
                }
                return GeminiContent.GeminiPart.builder().fileData(new GeminiContent.GeminiPart.GeminiFileData((String)Utils.getOrDefault((Object)image.mimeType(), (Object)mimeTypeDetector.probeContentType(url)), url.toString())).build();
            }
            throw new IllegalArgumentException("Image should contain either base64 data or url");
        }
        if (content instanceof AudioContent) {
            AudioContent audioContent = (AudioContent)content;
            URI uri = audioContent.audio().url();
            if (uri != null) {
                if (uri.getScheme() != null && uri.getScheme().equals("data")) {
                    return GeminiContent.GeminiPart.builder().inlineData(PartsAndContentsMapper.parseDataUri(uri)).build();
                }
                return GeminiContent.GeminiPart.builder().fileData(new GeminiContent.GeminiPart.GeminiFileData(mimeTypeDetector.probeContentType(uri), uri.toString())).build();
            }
            return GeminiContent.GeminiPart.builder().inlineData(new GeminiContent.GeminiPart.GeminiBlob(audioContent.audio().mimeType(), audioContent.audio().base64Data())).build();
        }
        if (content instanceof VideoContent) {
            VideoContent videoContent = (VideoContent)content;
            URI uri = videoContent.video().url();
            if (uri != null) {
                if (uri.getScheme() != null && uri.getScheme().equals("data")) {
                    return GeminiContent.GeminiPart.builder().inlineData(PartsAndContentsMapper.parseDataUri(uri)).build();
                }
                return GeminiContent.GeminiPart.builder().fileData(new GeminiContent.GeminiPart.GeminiFileData(mimeTypeDetector.probeContentType(uri), uri.toString())).build();
            }
            return GeminiContent.GeminiPart.builder().inlineData(new GeminiContent.GeminiPart.GeminiBlob(videoContent.video().mimeType(), videoContent.video().base64Data())).build();
        }
        if (content instanceof PdfFileContent) {
            PdfFileContent pdfFileContent = (PdfFileContent)content;
            PdfFile pdfFile = pdfFileContent.pdfFile();
            URI uri = pdfFile.url();
            if (uri != null) {
                if (uri.getScheme() != null && uri.getScheme().equals("data")) {
                    return GeminiContent.GeminiPart.builder().inlineData(PartsAndContentsMapper.parseDataUri(uri)).build();
                }
                return GeminiContent.GeminiPart.builder().fileData(new GeminiContent.GeminiPart.GeminiFileData(mimeTypeDetector.probeContentType(uri), uri.toString())).build();
            }
            return GeminiContent.GeminiPart.builder().inlineData(new GeminiContent.GeminiPart.GeminiBlob(pdfFile.mimeType(), pdfFile.base64Data())).build();
        }
        throw new UnsupportedFeatureException("Unsupported content type: " + String.valueOf(content.type()));
    }

    static AiMessage fromGPartsToAiMessage(List<GeminiContent.GeminiPart> parts, boolean includeCodeExecutionOutput, Boolean returnThinking) {
        List<GeminiContent.GeminiPart> safeParts = Objects.requireNonNullElse(parts, List.of());
        StringBuilder fullText = new StringBuilder();
        ArrayList<String> thoughts = new ArrayList<String>();
        ArrayList<String> thoughtSignatures = new ArrayList<String>();
        ArrayList<GeminiContent.GeminiPart.GeminiFunctionCall> functionCalls = new ArrayList<GeminiContent.GeminiPart.GeminiFunctionCall>();
        ArrayList<Image> generatedImages = new ArrayList<Image>();
        for (GeminiContent.GeminiPart part : safeParts) {
            GeminiContent.GeminiPart.GeminiBlob inlineData;
            String text;
            GeminiContent.GeminiPart.GeminiCodeExecutionResult codeExecutionResult;
            GeminiContent.GeminiPart.GeminiExecutableCode executableCode = part.executableCode();
            if (executableCode != null && includeCodeExecutionOutput) {
                fullText.append("Code executed:\n").append("```python").append(executableCode.programmingLanguage() != null ? executableCode.programmingLanguage().toString() : "").append(executableCode.code()).append("```\n");
            }
            if ((codeExecutionResult = part.codeExecutionResult()) != null && includeCodeExecutionOutput) {
                GeminiContent.GeminiPart.GeminiCodeExecutionResult.GeminiOutcome outcome = codeExecutionResult.outcome();
                if (outcome != GeminiContent.GeminiPart.GeminiCodeExecutionResult.GeminiOutcome.OUTCOME_OK) {
                    fullText.append("Code execution failed: **").append(outcome.name()).append("**\n").append(part.text() != null ? part.text() : "");
                } else {
                    fullText.append("Output:\n").append("```\n").append(codeExecutionResult.output()).append("```\n");
                }
            }
            if (Utils.isNotNullOrEmpty((String)(text = part.text()))) {
                if (Boolean.TRUE.equals(part.isThought())) {
                    if (Boolean.TRUE.equals(returnThinking)) {
                        thoughts.add(text);
                    } else if (returnThinking == null) {
                        if (!fullText.isEmpty()) {
                            fullText.append("\n\n");
                        }
                        fullText.append(text);
                    }
                } else {
                    if (!fullText.isEmpty()) {
                        fullText.append("\n\n");
                    }
                    fullText.append(text);
                }
            }
            String thoughtSignature = part.thoughtSignature();
            if (Boolean.TRUE.equals(returnThinking) && Utils.isNotNullOrEmpty((String)thoughtSignature)) {
                thoughtSignatures.add(thoughtSignature);
            }
            if (part.functionCall() != null) {
                functionCalls.add(part.functionCall());
            }
            if ((inlineData = part.inlineData()) == null || inlineData.mimeType() == null || !inlineData.mimeType().startsWith("image/") || inlineData.data() == null) continue;
            Image generatedImage = Image.builder().base64Data(inlineData.data()).mimeType(inlineData.mimeType()).build();
            generatedImages.add(generatedImage);
        }
        String text = fullText.toString();
        String thinking = thoughts.stream().collect(Collectors.joining("\n\n"));
        String thinkingSignature = thoughtSignatures.stream().collect(Collectors.joining("\n\n"));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (Utils.isNotNullOrEmpty((String)thinkingSignature)) {
            attributes.put(THINKING_SIGNATURE_KEY, thinkingSignature);
        }
        if (!generatedImages.isEmpty()) {
            attributes.put(GENERATED_IMAGES_KEY, generatedImages);
        }
        return AiMessage.builder().text(Utils.isNullOrEmpty((String)text) ? null : text).thinking(Utils.isNullOrEmpty((String)thinking) ? null : thinking).toolExecutionRequests(FunctionMapper.toToolExecutionRequests(functionCalls)).attributes(attributes.isEmpty() ? Map.of() : attributes).build();
    }

    static List<GeminiContent> fromMessageToGContent(List<ChatMessage> messages, GeminiContent systemInstruction, boolean sendThinking) {
        return messages.stream().map(msg -> {
            switch (msg.type()) {
                case SYSTEM: {
                    SystemMessage systemMessage = (SystemMessage)msg;
                    if (systemInstruction != null) {
                        systemInstruction.addPart(GeminiContent.GeminiPart.builder().text(systemMessage.text()).build());
                        return null;
                    }
                    if (Utils.isNotNullOrEmpty((String)systemMessage.text())) {
                        return new GeminiContent(List.of(GeminiContent.GeminiPart.builder().text(systemMessage.text()).build()), GeminiRole.MODEL.toString());
                    }
                    return null;
                }
                case AI: {
                    AiMessage aiMessage = (AiMessage)msg;
                    ArrayList<GeminiContent.GeminiPart> parts = new ArrayList<GeminiContent.GeminiPart>();
                    if (sendThinking && Utils.isNotNullOrEmpty((String)aiMessage.thinking())) {
                        parts.add(GeminiContent.GeminiPart.builder().text(aiMessage.thinking()).thought(true).build());
                    }
                    if (Utils.isNotNullOrEmpty((String)aiMessage.text())) {
                        parts.add(GeminiContent.GeminiPart.builder().text(aiMessage.text()).build());
                    }
                    if (aiMessage.hasToolExecutionRequests()) {
                        String thoughtSignature = null;
                        if (sendThinking) {
                            thoughtSignature = (String)aiMessage.attribute(THINKING_SIGNATURE_KEY, String.class);
                        }
                        parts.addAll(PartsAndContentsMapper.toGeminiParts(aiMessage.toolExecutionRequests(), thoughtSignature));
                    }
                    return new GeminiContent(parts, GeminiRole.MODEL.toString());
                }
                case USER: {
                    UserMessage userMessage = (UserMessage)msg;
                    return new GeminiContent(userMessage.contents().stream().map(PartsAndContentsMapper::fromContentToGPart).toList(), GeminiRole.USER.toString());
                }
                case TOOL_EXECUTION_RESULT: {
                    ToolExecutionResultMessage toolResultMessage = (ToolExecutionResultMessage)msg;
                    return new GeminiContent(List.of(GeminiContent.GeminiPart.builder().functionResponse(new GeminiContent.GeminiPart.GeminiFunctionResponse(toolResultMessage.toolName(), Map.of("response", toolResultMessage.text()))).build()), GeminiRole.USER.toString());
                }
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private static GeminiContent.GeminiPart.GeminiBlob parseDataUri(URI uri) {
        String urlString = uri.toString();
        Matcher matcher = DATA_URI_PATTERN.matcher(urlString);
        if (matcher.matches()) {
            String mimeType = matcher.group(1);
            String base64Data = matcher.group(2);
            return new GeminiContent.GeminiPart.GeminiBlob(mimeType, base64Data);
        }
        throw new IllegalArgumentException("Invalid data URI format: " + urlString);
    }

    private static List<GeminiContent.GeminiPart> toGeminiParts(List<ToolExecutionRequest> toolExecutionRequests, String thoughtSignature) {
        ArrayList<GeminiContent.GeminiPart> geminiParts = new ArrayList<GeminiContent.GeminiPart>();
        for (int i = 0; i < toolExecutionRequests.size(); ++i) {
            ToolExecutionRequest toolExecutionRequest = toolExecutionRequests.get(i);
            boolean shouldAddThoughtSignature = i == 0 && Utils.isNotNullOrEmpty((String)thoughtSignature);
            GeminiContent.GeminiPart geminiPart = GeminiContent.GeminiPart.builder().functionCall(new GeminiContent.GeminiPart.GeminiFunctionCall(toolExecutionRequest.name(), Json.fromJson(toolExecutionRequest.arguments(), Map.class))).thoughtSignature(shouldAddThoughtSignature ? thoughtSignature : null).build();
            geminiParts.add(geminiPart);
        }
        return geminiParts;
    }
}

