/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.github;

import com.azure.ai.inference.ChatCompletionsClient;
import com.azure.ai.inference.ModelServiceVersion;
import com.azure.ai.inference.models.ChatChoice;
import com.azure.ai.inference.models.ChatCompletions;
import com.azure.ai.inference.models.ChatCompletionsOptions;
import com.azure.ai.inference.models.ChatCompletionsResponseFormat;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.github.GitHubModelsChatModelName;
import dev.langchain4j.model.github.InternalGitHubModelHelper;
import dev.langchain4j.model.github.spi.GitHubModelsChatModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubModelsChatModel
implements ChatLanguageModel {
    private static final Logger logger = LoggerFactory.getLogger(GitHubModelsChatModel.class);
    private ChatCompletionsClient client;
    private final String modelName;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final Long seed;
    private final ChatCompletionsResponseFormat responseFormat;
    private final List<ChatModelListener> listeners;

    private GitHubModelsChatModel(ChatCompletionsClient client, String modelName, Integer maxTokens, Double temperature, Double topP, List<String> stop, Double presencePenalty, Double frequencyPenalty, Long seed, ChatCompletionsResponseFormat responseFormat, List<ChatModelListener> listeners) {
        this(modelName, maxTokens, temperature, topP, stop, presencePenalty, frequencyPenalty, seed, responseFormat, listeners);
        this.client = client;
    }

    private GitHubModelsChatModel(String endpoint, ModelServiceVersion serviceVersion, String gitHubToken, String modelName, Integer maxTokens, Double temperature, Double topP, List<String> stop, Double presencePenalty, Double frequencyPenalty, Long seed, ChatCompletionsResponseFormat responseFormat, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders) {
        this(modelName, maxTokens, temperature, topP, stop, presencePenalty, frequencyPenalty, seed, responseFormat, listeners);
        this.client = InternalGitHubModelHelper.setupChatCompletionsBuilder(endpoint, serviceVersion, gitHubToken, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders).buildClient();
    }

    private GitHubModelsChatModel(String modelName, Integer maxTokens, Double temperature, Double topP, List<String> stop, Double presencePenalty, Double frequencyPenalty, Long seed, ChatCompletionsResponseFormat responseFormat, List<ChatModelListener> listeners) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.stop = Utils.copyIfNotNull(stop);
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.seed = seed;
        this.responseFormat = responseFormat;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        ChatCompletionsOptions options = new ChatCompletionsOptions(InternalGitHubModelHelper.toAzureAiMessages(messages)).setModel(this.modelName).setMaxTokens(this.maxTokens).setTemperature(this.temperature).setTopP(this.topP).setStop(this.stop).setPresencePenalty(this.presencePenalty).setFrequencyPenalty(this.frequencyPenalty).setSeed(this.seed).setResponseFormat(this.responseFormat);
        if (toolThatMustBeExecuted != null) {
            options.setTools(InternalGitHubModelHelper.toToolDefinitions(Collections.singletonList(toolThatMustBeExecuted)));
            options.setToolChoice(InternalGitHubModelHelper.toToolChoice(toolThatMustBeExecuted));
        }
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            options.setTools(InternalGitHubModelHelper.toToolDefinitions(toolSpecifications));
        }
        ChatModelRequest modelListenerRequest = InternalGitHubModelHelper.createModelListenerRequest(options, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                logger.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            ChatCompletions chatCompletions = this.client.complete(options);
            Response response = Response.from((Object)InternalGitHubModelHelper.aiMessageFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getMessage()), (TokenUsage)InternalGitHubModelHelper.tokenUsageFrom(chatCompletions.getUsage()), (FinishReason)InternalGitHubModelHelper.finishReasonFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getFinishReason()));
            ChatModelResponse modelListenerResponse = InternalGitHubModelHelper.createModelListenerResponse(chatCompletions.getId(), options.getModel(), (Response<AiMessage>)response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    logger.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return response;
        }
        catch (HttpResponseException httpResponseException) {
            logger.info("Error generating response, {}", httpResponseException.getValue());
            FinishReason exceptionFinishReason = InternalGitHubModelHelper.contentFilterManagement(httpResponseException, "content_filter");
            Response response = Response.from((Object)AiMessage.aiMessage((String)httpResponseException.getMessage()), null, (FinishReason)exceptionFinishReason);
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)httpResponseException, modelListenerRequest, null, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    logger.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            return response;
        }
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(GitHubModelsChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            GitHubModelsChatModelBuilderFactory factory = (GitHubModelsChatModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private ModelServiceVersion serviceVersion;
        private String gitHubToken;
        private String modelName;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Long seed;
        private ChatCompletionsResponseFormat responseFormat;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private ChatCompletionsClient chatCompletionsClient;
        private String userAgentSuffix;
        private List<ChatModelListener> listeners;
        private Map<String, String> customHeaders;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(ModelServiceVersion serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder gitHubToken(String gitHubToken) {
            this.gitHubToken = gitHubToken;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder modelName(GitHubModelsChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Builder responseFormat(ChatCompletionsResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder userAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public Builder chatCompletionsClient(ChatCompletionsClient chatCompletionsClient) {
            this.chatCompletionsClient = chatCompletionsClient;
            return this;
        }

        public Builder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public GitHubModelsChatModel build() {
            if (this.chatCompletionsClient == null) {
                return new GitHubModelsChatModel(this.endpoint, this.serviceVersion, this.gitHubToken, this.modelName, this.maxTokens, this.temperature, this.topP, this.stop, this.presencePenalty, this.frequencyPenalty, this.seed, this.responseFormat, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.listeners, this.userAgentSuffix, this.customHeaders);
            }
            return new GitHubModelsChatModel(this.chatCompletionsClient, this.modelName, this.maxTokens, this.temperature, this.topP, this.stop, this.presencePenalty, this.frequencyPenalty, this.seed, this.responseFormat, this.listeners);
        }
    }
}

