/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser.apache.pdfbox;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.text.PDFTextStripper;

public class ApachePdfBoxDocumentParser
implements DocumentParser {
    private final boolean includeMetadata;

    public ApachePdfBoxDocumentParser() {
        this(false);
    }

    public ApachePdfBoxDocumentParser(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public Document parse(InputStream inputStream) {
        Document document;
        block9: {
            PDDocument pdfDocument = PDDocument.load((InputStream)inputStream);
            try {
                PDFTextStripper stripper = new PDFTextStripper();
                String text = stripper.getText(pdfDocument);
                if (Utils.isNullOrBlank((String)text)) {
                    throw new BlankDocumentException();
                }
                Document document2 = document = this.includeMetadata ? Document.from((String)text, (Metadata)this.toMetadata(pdfDocument)) : Document.from((String)text);
                if (pdfDocument == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pdfDocument != null) {
                        try {
                            pdfDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pdfDocument.close();
        }
        return document;
    }

    private Metadata toMetadata(PDDocument pdDocument) {
        PDDocumentInformation documentInformation = pdDocument.getDocumentInformation();
        Metadata metadata = new Metadata();
        for (String metadataKey : documentInformation.getMetadataKeys()) {
            String value = documentInformation.getCustomMetadataValue(metadataKey);
            if (value == null) continue;
            metadata.put(metadataKey, value);
        }
        return metadata;
    }
}

