/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.options.LoadState;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.Metadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightDocumentLoader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PlaywrightDocumentLoader.class);
    private final Browser browser;

    private PlaywrightDocumentLoader(Browser browser) {
        this.browser = Objects.requireNonNull(browser, "browser must not be null");
    }

    public Document load(String url) {
        String pageContent = this.pageContent(url);
        return Document.from((String)pageContent, (Metadata)Metadata.from((String)"url", (String)url));
    }

    public Document load(String url, DocumentParser documentParser) {
        Objects.requireNonNull(documentParser, "documentParser must not be null");
        String pageContent = this.pageContent(url);
        Document parsedDocument = documentParser.parse((InputStream)new ByteArrayInputStream(pageContent.getBytes()));
        parsedDocument.metadata().put("url", url);
        return parsedDocument;
    }

    public String pageContent(String url) {
        String string;
        block8: {
            Objects.requireNonNull(url, "url must not be null");
            logger.info("Loading document from URL: {}", (Object)url);
            Page page = this.browser.newPage();
            try {
                logger.info("Navigating to URL: {}", (Object)url);
                page.navigate(url);
                page.waitForLoadState(LoadState.DOMCONTENTLOADED);
                logger.debug("Web page fully loaded: {}", (Object)url);
                string = page.content();
                if (page == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (page != null) {
                        try {
                            page.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load document from URL: " + url, e);
                }
            }
            page.close();
        }
        return string;
    }

    @Override
    public void close() {
        if (this.browser != null) {
            try {
                this.browser.close();
                logger.info("Browser closed successfully.");
            }
            catch (Exception e) {
                logger.warn("Error closing Browser", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Browser browser;

        public Builder browser(Browser browser) {
            this.browser = browser;
            return this;
        }

        public PlaywrightDocumentLoader build() {
            Objects.requireNonNull(this.browser, "browser must be set");
            return new PlaywrightDocumentLoader(this.browser);
        }
    }
}

