/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.github;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.source.github.GitHubSource;
import dev.langchain4j.internal.RetryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubDocumentLoader {
    private static final Logger logger = LoggerFactory.getLogger(GitHubDocumentLoader.class);
    private final GitHub gitHub;

    public GitHubDocumentLoader(String gitHubToken, String gitHubTokenOrganization) {
        this(null, gitHubToken, gitHubTokenOrganization);
    }

    public GitHubDocumentLoader(String apiUrl, String gitHubToken, String gitHubTokenOrganization) {
        GitHubBuilder gitHubBuilder = new GitHubBuilder();
        if (apiUrl != null) {
            gitHubBuilder.withEndpoint(apiUrl);
        }
        if (gitHubToken != null) {
            if (gitHubTokenOrganization == null) {
                gitHubBuilder.withOAuthToken(gitHubToken);
            } else {
                gitHubBuilder.withOAuthToken(gitHubToken, gitHubTokenOrganization);
            }
        }
        try {
            this.gitHub = gitHubBuilder.build();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public GitHubDocumentLoader() {
        try {
            this.gitHub = new GitHubBuilder().build();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public GitHubDocumentLoader(GitHub gitHub) {
        this.gitHub = gitHub;
    }

    public Document loadDocument(String owner, String repo, String branch, String path, DocumentParser parser) {
        GHContent content = null;
        try {
            content = this.gitHub.getRepository(owner + "/" + repo).getFileContent(path, branch);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return GitHubDocumentLoader.fromGitHub(parser, content);
    }

    public List<Document> loadDocuments(String owner, String repo, String branch, String path, DocumentParser parser) {
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            this.gitHub.getRepository(owner + "/" + repo).getDirectoryContent(path, branch).forEach(ghDirectoryContent -> GitHubDocumentLoader.scanDirectory(ghDirectoryContent, documents, parser));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return documents;
    }

    public List<Document> loadDocuments(String owner, String repo, String branch, DocumentParser parser) {
        return this.loadDocuments(owner, repo, branch, "", parser);
    }

    private static void scanDirectory(GHContent ghContent, List<Document> documents, DocumentParser parser) {
        if (ghContent.isDirectory()) {
            try {
                ghContent.listDirectoryContent().forEach(ghDirectoryContent -> GitHubDocumentLoader.scanDirectory(ghDirectoryContent, documents, parser));
            }
            catch (IOException ioException) {
                logger.error("Failed to read directory from GitHub: {}", (Object)ghContent.getHtmlUrl(), (Object)ioException);
            }
        } else {
            Document document = null;
            try {
                document = (Document)RetryUtils.withRetry(() -> GitHubDocumentLoader.fromGitHub(parser, ghContent), (int)3);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Failed to read document from GitHub: {}", (Object)ghContent.getHtmlUrl(), (Object)runtimeException);
            }
            if (document != null) {
                documents.add(document);
            }
        }
    }

    private static Document fromGitHub(DocumentParser parser, GHContent content) {
        logger.info("Loading document from GitHub: {}", (Object)content.getHtmlUrl());
        try {
            if (content.isFile()) {
                GitHubSource source = new GitHubSource(content);
                return DocumentLoader.load((DocumentSource)source, (DocumentParser)parser);
            }
            throw new IllegalArgumentException("Content must be a file, and not a directory: " + content.getHtmlUrl());
        }
        catch (IOException ioException) {
            throw new RuntimeException("Failed to load document from GitHub: {}", ioException);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiUrl;
        private String gitHubToken;
        private String gitHubTokenOrganization;

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder gitHubToken(String gitHubToken) {
            this.gitHubToken = gitHubToken;
            return this;
        }

        public Builder gitHubTokenOrganization(String gitHubTokenOrganization) {
            this.gitHubTokenOrganization = gitHubTokenOrganization;
            return this;
        }

        public GitHubDocumentLoader build() {
            return new GitHubDocumentLoader(this.apiUrl, this.gitHubToken, this.gitHubTokenOrganization);
        }
    }
}

