/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.source.amazon.s3;

import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;

public class AmazonS3Source
implements DocumentSource {
    public static final String SOURCE = "source";
    private final InputStream inputStream;
    private final String bucket;
    private final String key;

    public AmazonS3Source(InputStream inputStream, String bucket, String key) {
        this.inputStream = (InputStream)ValidationUtils.ensureNotNull((Object)inputStream, (String)"inputStream");
        this.bucket = ValidationUtils.ensureNotBlank((String)bucket, (String)"bucket");
        this.key = ValidationUtils.ensureNotBlank((String)key, (String)"key");
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public Metadata metadata() {
        return Metadata.from((String)SOURCE, (String)String.format("s3://%s/%s", this.bucket, this.key));
    }
}

