/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.amazon.s3;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.loader.amazon.s3.AwsCredentials;
import dev.langchain4j.data.document.source.amazon.s3.AmazonS3Source;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AmazonS3DocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3DocumentLoader.class);
    private final S3Client s3Client;

    public AmazonS3DocumentLoader(S3Client s3Client) {
        this.s3Client = (S3Client)ValidationUtils.ensureNotNull((Object)s3Client, (String)"s3Client");
    }

    public Document loadDocument(String bucket, String key, DocumentParser parser) {
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(ValidationUtils.ensureNotBlank((String)bucket, (String)"bucket")).key(ValidationUtils.ensureNotBlank((String)key, (String)"key")).build();
            ResponseInputStream inputStream = this.s3Client.getObject(getObjectRequest);
            AmazonS3Source source = new AmazonS3Source((InputStream)inputStream, bucket, key);
            return DocumentLoader.load((DocumentSource)source, (DocumentParser)parser);
        }
        catch (S3Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Document> loadDocuments(String bucket, DocumentParser parser) {
        return this.loadDocuments(bucket, null, parser);
    }

    public List<Document> loadDocuments(String bucket, String prefix, DocumentParser parser) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(ValidationUtils.ensureNotBlank((String)bucket, (String)"bucket")).prefix(prefix).build();
        ListObjectsV2Response listObjectsV2Response = this.s3Client.listObjectsV2(listObjectsV2Request);
        List filteredS3Objects = listObjectsV2Response.contents().stream().filter(s3Object -> !s3Object.key().endsWith("/") && s3Object.size() > 0L).collect(Collectors.toList());
        for (S3Object s3Object2 : filteredS3Objects) {
            String key = s3Object2.key();
            try {
                Document document = this.loadDocument(bucket, key, parser);
                documents.add(document);
            }
            catch (Exception e) {
                log.warn("Failed to load an object with key '{}' from bucket '{}', skipping it.", new Object[]{key, bucket, e});
            }
        }
        return documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Region region = Region.US_EAST_1;
        private String endpointUrl;
        private String profile;
        private boolean forcePathStyle;
        private AwsCredentials awsCredentials;

        public Builder region(String region) {
            this.region = Region.of((String)region);
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder forcePathStyle(boolean forcePathStyle) {
            this.forcePathStyle = forcePathStyle;
            return this;
        }

        public Builder awsCredentials(AwsCredentials awsCredentials) {
            this.awsCredentials = awsCredentials;
            return this;
        }

        public AmazonS3DocumentLoader build() {
            AwsCredentialsProvider credentialsProvider = this.createCredentialsProvider();
            S3Client s3Client = this.createS3Client(credentialsProvider);
            return new AmazonS3DocumentLoader(s3Client);
        }

        private AwsCredentialsProvider createCredentialsProvider() {
            if (!Utils.isNullOrBlank((String)this.profile)) {
                return ProfileCredentialsProvider.create((String)this.profile);
            }
            if (this.awsCredentials != null) {
                return this.awsCredentials.toCredentialsProvider();
            }
            return DefaultCredentialsProvider.builder().build();
        }

        private S3Client createS3Client(AwsCredentialsProvider credentialsProvider) {
            S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.region)).forcePathStyle(Boolean.valueOf(this.forcePathStyle))).credentialsProvider(credentialsProvider);
            if (!Utils.isNullOrBlank((String)this.endpointUrl)) {
                try {
                    s3ClientBuilder.endpointOverride(new URI(this.endpointUrl));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return (S3Client)s3ClientBuilder.build();
        }
    }
}

