/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UserMessage
implements ChatMessage {
    private final String name;
    private final List<Content> contents;

    public UserMessage(String text) {
        this(TextContent.from(text));
    }

    public UserMessage(String name, String text) {
        this(name, TextContent.from(text));
    }

    public UserMessage(Content ... contents) {
        this(Arrays.asList(contents));
    }

    public UserMessage(String name, Content ... contents) {
        this(name, Arrays.asList(contents));
    }

    public UserMessage(List<Content> contents) {
        this.name = null;
        this.contents = Collections.unmodifiableList(ValidationUtils.ensureNotEmpty(contents, "contents"));
    }

    public UserMessage(String name, List<Content> contents) {
        this.name = name;
        this.contents = Collections.unmodifiableList(ValidationUtils.ensureNotEmpty(contents, "contents"));
    }

    public String name() {
        return this.name;
    }

    public List<Content> contents() {
        return this.contents;
    }

    public String singleText() {
        if (this.hasSingleText()) {
            return ((TextContent)this.contents.get(0)).text();
        }
        throw Exceptions.runtime("Expecting single text content, but got: " + String.valueOf(this.contents), new Object[0]);
    }

    public boolean hasSingleText() {
        return this.contents.size() == 1 && this.contents.get(0) instanceof TextContent;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.USER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMessage that = (UserMessage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contents);
    }

    public String toString() {
        return "UserMessage { name = " + Utils.quoted(this.name) + " contents = " + String.valueOf(this.contents) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UserMessage from(String text) {
        return new UserMessage(text);
    }

    public static UserMessage from(String name, String text) {
        return new UserMessage(name, text);
    }

    public static UserMessage from(Content ... contents) {
        return new UserMessage(contents);
    }

    public static UserMessage from(String name, Content ... contents) {
        return new UserMessage(name, contents);
    }

    public static UserMessage from(List<Content> contents) {
        return new UserMessage(contents);
    }

    public static UserMessage from(String name, List<Content> contents) {
        return new UserMessage(name, contents);
    }

    public static UserMessage userMessage(String text) {
        return UserMessage.from(text);
    }

    public static UserMessage userMessage(String name, String text) {
        return UserMessage.from(name, text);
    }

    public static UserMessage userMessage(Content ... contents) {
        return UserMessage.from(contents);
    }

    public static UserMessage userMessage(String name, Content ... contents) {
        return UserMessage.from(name, contents);
    }

    public static UserMessage userMessage(List<Content> contents) {
        return UserMessage.from(contents);
    }

    public static UserMessage userMessage(String name, List<Content> contents) {
        return UserMessage.from(name, contents);
    }

    public static class Builder {
        private String name;
        private List<Content> contents;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder contents(List<Content> contents) {
            this.contents = contents;
            return this;
        }

        @Experimental
        public Builder addContent(Content content) {
            if (this.contents == null) {
                this.contents = new ArrayList<Content>();
            }
            this.contents.add(content);
            return this;
        }

        public UserMessage build() {
            return new UserMessage(this.name, this.contents);
        }
    }
}

