/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import java.util.Arrays;
import java.util.List;

public interface ChatLanguageModel {
    default public AiMessage sendUserMessage(String userMessage) {
        return this.sendUserMessage(UserMessage.from(userMessage));
    }

    default public AiMessage sendUserMessage(UserMessage userMessage) {
        return this.sendMessages(userMessage);
    }

    default public AiMessage sendUserMessage(Object structuredPrompt) {
        Prompt prompt = StructuredPromptProcessor.toPrompt(structuredPrompt);
        return this.sendUserMessage(prompt.toUserMessage());
    }

    default public AiMessage sendMessages(ChatMessage ... messages) {
        return this.sendMessages(Arrays.asList(messages));
    }

    public AiMessage sendMessages(List<ChatMessage> var1);

    public AiMessage sendMessages(List<ChatMessage> var1, List<ToolSpecification> var2);
}

