/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.community.model.dashscope.QwenChatRequestParameters;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.QwenPartialResponse;
import dev.langchain4j.community.model.dashscope.QwenStreamingResponseBuilder;
import dev.langchain4j.community.model.dashscope.spi.QwenStreamingChatModelBuilderFactory;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.spi.ServiceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class QwenStreamingChatModel
implements StreamingChatModel {
    private final QwenChatRequestParameters defaultRequestParameters;
    private final String apiKey;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final List<ChatModelListener> listeners;
    private Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer = p -> {};
    private Consumer<MultiModalConversationParam.MultiModalConversationParamBuilder<?, ?>> multimodalConversationParamCustomizer = p -> {};

    public QwenStreamingChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens, List<ChatModelListener> listeners, ChatRequestParameters defaultRequestParameters, Boolean isMultimodalModel) {
        QwenChatRequestParameters qwenChatRequestParameters;
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. Reference: https://www.alibabacloud.com/help/en/model-studio/get-api-key");
        }
        ChatRequestParameters commonParameters = defaultRequestParameters != null ? defaultRequestParameters : DefaultChatRequestParameters.builder().build();
        QwenChatRequestParameters qwenParameters = defaultRequestParameters instanceof QwenChatRequestParameters ? (qwenChatRequestParameters = (QwenChatRequestParameters)defaultRequestParameters) : QwenChatRequestParameters.builder().build();
        Double temperatureParameter = Objects.isNull(temperature) ? null : Double.valueOf(temperature.doubleValue());
        Double frequencyPenaltyParameter = QwenHelper.repetitionPenaltyToFrequencyPenalty(repetitionPenalty);
        String modelNameParameter = (String)Utils.getOrDefault((Object)modelName, (Object)commonParameters.modelName());
        this.apiKey = apiKey;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.defaultRequestParameters = ((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)QwenChatRequestParameters.builder().modelName(modelNameParameter)).temperature((Double)Utils.getOrDefault((Object)temperatureParameter, (Object)commonParameters.temperature()))).topP((Double)Utils.getOrDefault((Object)topP, (Object)commonParameters.topP()))).topK((Integer)Utils.getOrDefault((Object)topK, (Object)commonParameters.topK()))).frequencyPenalty((Double)Utils.getOrDefault((Object)frequencyPenaltyParameter, (Object)commonParameters.frequencyPenalty()))).presencePenalty(commonParameters.presencePenalty())).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxTokens, (Object)commonParameters.maxOutputTokens()))).stopSequences((List)Utils.getOrDefault(stops, () -> Utils.copyIfNotNull((List)commonParameters.stopSequences())))).toolSpecifications(Utils.copyIfNotNull((List)commonParameters.toolSpecifications()))).toolChoice(commonParameters.toolChoice())).responseFormat(commonParameters.responseFormat())).seed((Integer)Utils.getOrDefault((Object)seed, (Object)qwenParameters.seed())).enableSearch((Boolean)Utils.getOrDefault((Object)enableSearch, (Object)qwenParameters.enableSearch())).searchOptions(qwenParameters.searchOptions()).translationOptions(qwenParameters.translationOptions()).vlHighResolutionImages(qwenParameters.vlHighResolutionImages()).isMultimodalModel((Boolean)Utils.getOrDefault((Object)isMultimodalModel, (Object)qwenParameters.isMultimodalModel())).supportIncrementalOutput(qwenParameters.supportIncrementalOutput()).enableThinking(qwenParameters.enableThinking()).thinkingBudget(qwenParameters.thinkingBudget()).enableSanitizeMessages(qwenParameters.enableSanitizeMessages()).custom(Utils.copyIfNotNull(qwenParameters.custom())).build();
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = new MultiModalConversation();
            this.generation = new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl);
            this.generation = new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl);
            this.generation = new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    private void generateByNonMultimodalModel(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        boolean incrementalOutput = QwenHelper.supportIncrementalOutput(chatRequest);
        GenerationParam param = QwenHelper.toGenerationParam(this.apiKey, chatRequest, this.generationParamCustomizer, incrementalOutput);
        final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder(param.getModel(), incrementalOutput);
        try {
            this.generation.streamCall((HalfDuplexServiceParam)param, (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    try {
                        List<CompleteToolCall> completeToolCalls;
                        List<PartialToolCall> partialToolCalls;
                        QwenPartialResponse partialResponse = responseBuilder.append(result);
                        if (Utils.isNotNullOrEmpty((String)partialResponse.delta())) {
                            handler.onPartialResponse(partialResponse.delta());
                        }
                        if (partialResponse.partialThinking() != null) {
                            handler.onPartialThinking(partialResponse.partialThinking());
                        }
                        if (!Utils.isNullOrEmpty(partialToolCalls = partialResponse.partialToolCalls())) {
                            for (PartialToolCall toolCall : partialToolCalls) {
                                handler.onPartialToolCall(toolCall);
                            }
                        }
                        if (!Utils.isNullOrEmpty(completeToolCalls = partialResponse.completeToolCalls())) {
                            for (CompleteToolCall toolCall : completeToolCalls) {
                                handler.onCompleteToolCall(toolCall);
                            }
                        }
                    }
                    catch (Throwable t) {
                        RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(t);
                        InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
                    }
                }

                public void onComplete() {
                    try {
                        handler.onCompleteResponse(responseBuilder.build());
                        CompleteToolCall completeToolCall = responseBuilder.buildCompleteToolCall();
                        if (completeToolCall != null) {
                            handler.onCompleteToolCall(completeToolCall);
                        }
                    }
                    catch (Throwable t) {
                        RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(t);
                        InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
                    }
                }

                public void onError(Exception e) {
                    RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException((Throwable)e);
                    InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void generateByMultimodalModel(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        boolean incrementalOutput = QwenHelper.supportIncrementalOutput(chatRequest);
        MultiModalConversationParam param = QwenHelper.toMultiModalConversationParam(this.apiKey, chatRequest, this.multimodalConversationParamCustomizer, incrementalOutput);
        final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder(param.getModel(), incrementalOutput);
        try {
            this.conv.streamCall(param, (ResultCallback)new ResultCallback<MultiModalConversationResult>(){

                public void onEvent(MultiModalConversationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrEmpty((String)delta)) {
                        handler.onPartialResponse(delta);
                    }
                }

                public void onComplete() {
                    handler.onCompleteResponse(responseBuilder.build());
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UploadFileException e) {
            throw new IllegalStateException(e);
        }
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        if (QwenHelper.isMultimodalModel(chatRequest)) {
            this.generateByMultimodalModel(chatRequest, handler);
        } else {
            this.generateByNonMultimodalModel(chatRequest, handler);
        }
    }

    public QwenChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public void setGenerationParamCustomizer(Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer) {
        this.generationParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(generationParamCustomizer, (String)"generationParamConsumer");
    }

    public void setMultimodalConversationParamCustomizer(Consumer<MultiModalConversationParam.MultiModalConversationParamBuilder<?, ?>> multimodalConversationParamCustomizer) {
        this.multimodalConversationParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(multimodalConversationParamCustomizer, (String)"multimodalConversationParamCustomizer");
    }

    public static QwenStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenStreamingChatModelBuilderFactory factory = (QwenStreamingChatModelBuilderFactory)iterator.next();
            return (QwenStreamingChatModelBuilder)factory.get();
        }
        return new QwenStreamingChatModelBuilder();
    }

    public static class QwenStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;
        private List<ChatModelListener> listeners;
        private ChatRequestParameters defaultRequestParameters;
        private Boolean isMultimodalModel;

        public QwenStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenStreamingChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenStreamingChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenStreamingChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenStreamingChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenStreamingChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QwenStreamingChatModelBuilder defaultRequestParameters(ChatRequestParameters defaultRequestParameters) {
            this.defaultRequestParameters = defaultRequestParameters;
            return this;
        }

        public QwenStreamingChatModelBuilder isMultimodalModel(Boolean isMultimodalModel) {
            this.isMultimodalModel = isMultimodalModel;
            return this;
        }

        public QwenStreamingChatModel build() {
            return new QwenStreamingChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens, this.listeners, this.defaultRequestParameters, this.isMultimodalModel);
        }

        public String toString() {
            return "QwenStreamingChatModelBuilder{baseUrl=" + Utils.quoted((Object)this.baseUrl) + ", modelName='" + Utils.quoted((Object)this.modelName) + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch=" + this.enableSearch + ", seed=" + this.seed + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stops=" + String.valueOf(this.stops) + ", maxTokens=" + this.maxTokens + ", listeners=" + String.valueOf(this.listeners) + ", defaultRequestParameters=" + String.valueOf(this.defaultRequestParameters) + "}";
        }
    }
}

