/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.cohere;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.cohere.CohereApi;
import dev.langchain4j.model.cohere.EmbedRequest;
import dev.langchain4j.model.cohere.EmbedResponse;
import dev.langchain4j.model.cohere.RequestLoggingInterceptor;
import dev.langchain4j.model.cohere.RerankRequest;
import dev.langchain4j.model.cohere.RerankResponse;
import dev.langchain4j.model.cohere.ResponseLoggingInterceptor;
import java.io.IOException;
import java.net.Proxy;
import java.time.Duration;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class CohereClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final CohereApi cohereApi;
    private final String authorizationHeader;

    CohereClient(String baseUrl, String apiKey, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        if (Objects.nonNull(proxy)) {
            okHttpClientBuilder.proxy(proxy);
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.cohereApi = (CohereApi)retrofit.create(CohereApi.class);
        this.authorizationHeader = "Bearer " + ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
    }

    EmbedResponse embed(EmbedRequest request) {
        try {
            Response retrofitResponse = this.cohereApi.embed(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbedResponse)retrofitResponse.body();
            }
            throw CohereClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    RerankResponse rerank(RerankRequest request) {
        try {
            Response retrofitResponse = this.cohereApi.rerank(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return (RerankResponse)retrofitResponse.body();
            }
            throw CohereClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static CohereClientBuilder builder() {
        return new CohereClientBuilder();
    }

    public static class CohereClientBuilder {
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        CohereClientBuilder() {
        }

        public CohereClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public CohereClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public CohereClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public CohereClientBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public CohereClientBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public CohereClientBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public CohereClient build() {
            return new CohereClient(this.baseUrl, this.apiKey, this.timeout, this.proxy, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "CohereClient.CohereClientBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + String.valueOf(this.timeout) + ", proxy=" + String.valueOf(this.proxy) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

