/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.cohere;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.cohere.CohereApi;
import dev.langchain4j.model.cohere.RequestLoggingInterceptor;
import dev.langchain4j.model.cohere.RerankRequest;
import dev.langchain4j.model.cohere.RerankResponse;
import dev.langchain4j.model.cohere.ResponseLoggingInterceptor;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class CohereClient {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private final CohereApi cohereApi;
    private final String authorizationHeader;

    CohereClient(String baseUrl, String apiKey, Duration timeout, Boolean logRequests, Boolean logResponses) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.cohereApi = (CohereApi)retrofit.create(CohereApi.class);
        this.authorizationHeader = "Bearer " + ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
    }

    public RerankResponse rerank(RerankRequest request) {
        try {
            Response retrofitResponse = this.cohereApi.rerank(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return (RerankResponse)retrofitResponse.body();
            }
            throw CohereClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static CohereClientBuilder builder() {
        return new CohereClientBuilder();
    }

    public static class CohereClientBuilder {
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;

        CohereClientBuilder() {
        }

        public CohereClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public CohereClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public CohereClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public CohereClientBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public CohereClientBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public CohereClient build() {
            return new CohereClient(this.baseUrl, this.apiKey, this.timeout, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "CohereClient.CohereClientBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

