/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.code.judge0;

import dev.langchain4j.code.CodeExecutionEngine;
import dev.langchain4j.code.judge0.Json;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Judge0JavaScriptEngine
implements CodeExecutionEngine {
    private static final Logger log = LoggerFactory.getLogger(Judge0JavaScriptEngine.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private static final String RAPID_API_HOST = "judge0-ce.p.rapidapi.com";
    private static final String API_URL = "https://judge0-ce.p.rapidapi.com/submissions?base64_encoded=true&wait=true&fields=*";
    private static final int STATUS_ACCEPTED = 3;
    private static final String ERROR_RATE_LIMIT = "Rate limit exceeded. Please try again later.";
    private static final String ERROR_FORBIDDEN = "Access forbidden. Please check your API key.";
    private static final String ERROR_NOT_FOUND = "Resource not found. Please check the endpoint URL.";
    private static final String ERROR_SERVER = "Internal server error. Please try again later.";
    private static final String ERROR_UNAVAILABLE = "Service unavailable. Please try again later.";
    private static final String ERROR_NULL_RESPONSE = "Response body is null";
    private static final String ERROR_NO_STDOUT = "No result: nothing was printed out to the console";
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_DELAY_MS = 1000L;
    private final String apiKey;
    private final int languageId;
    private final OkHttpClient client;

    Judge0JavaScriptEngine(String apiKey, int languageId, Duration timeout) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("API key must not be null or blank");
        }
        Objects.requireNonNull(timeout, "Timeout must not be null");
        this.apiKey = apiKey;
        this.languageId = languageId;
        this.client = new OkHttpClient.Builder().connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).callTimeout(timeout).build();
    }

    public String execute(String code) {
        if (Utils.isNullOrBlank((String)code)) {
            return "Error: Cannot execute empty or null code";
        }
        String base64EncodedCode = Base64.getEncoder().encodeToString(code.getBytes(StandardCharsets.UTF_8));
        Submission submission = new Submission(this.languageId, base64EncodedCode);
        RequestBody requestBody = RequestBody.create((String)Json.toJson(submission), (MediaType)MEDIA_TYPE_JSON);
        Request request = this.buildRequest(requestBody);
        return this.executeWithRetry(request);
    }

    private Request buildRequest(RequestBody requestBody) {
        return new Request.Builder().url(API_URL).addHeader("x-rapidapi-host", RAPID_API_HOST).addHeader("x-rapidapi-key", this.apiKey).post(requestBody).build();
    }

    private String executeWithRetry(Request request) {
        Throwable lastException = null;
        for (int attempt = 0; attempt < 3; ++attempt) {
            if (attempt > 0) {
                try {
                    log.info("Retrying request, attempt {} of {}", (Object)(attempt + 1), (Object)3);
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return "Request interrupted: " + e.getMessage();
                }
            }
            try {
                return this.processRequest(request);
            }
            catch (IOException e) {
                lastException = e;
                log.warn("Request failed (attempt {}/{}): {}", new Object[]{attempt + 1, 3, e.getMessage()});
                continue;
            }
        }
        log.error("All retry attempts failed", lastException);
        return "Failed after 3 attempts: " + lastException.getMessage();
    }

    private String processRequest(Request request) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String string = this.handleErrorResponse(response);
                return string;
            }
            if (response.body() == null) {
                log.warn(ERROR_NULL_RESPONSE);
                String string = ERROR_NULL_RESPONSE;
                return string;
            }
            String responseBody = response.body().string();
            String string = this.processResponseBody(responseBody);
            return string;
        }
    }

    private String handleErrorResponse(Response response) {
        String errorMessage = switch (response.code()) {
            case 429 -> ERROR_RATE_LIMIT;
            case 403 -> ERROR_FORBIDDEN;
            case 404 -> ERROR_NOT_FOUND;
            case 500 -> ERROR_SERVER;
            case 503 -> ERROR_UNAVAILABLE;
            default -> "Unexpected error code " + response.code() + ": " + response.message();
        };
        log.warn(errorMessage);
        return errorMessage;
    }

    private String processResponseBody(String responseBody) {
        SubmissionResult result = Json.fromJson(responseBody, SubmissionResult.class);
        if (result.status.id != 3) {
            return this.formatErrorResult(result);
        }
        String base64EncodedStdout = result.stdout;
        if (base64EncodedStdout == null) {
            return ERROR_NO_STDOUT;
        }
        try {
            return new String(Base64.getMimeDecoder().decode(base64EncodedStdout.trim()), StandardCharsets.UTF_8).trim();
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to decode base64 output", (Throwable)e);
            return "Error decoding result: " + e.getMessage();
        }
    }

    private String formatErrorResult(SubmissionResult result) {
        StringBuilder error = new StringBuilder(result.status.description);
        if (!Utils.isNullOrBlank((String)result.compile_output)) {
            error.append("\n");
            try {
                error.append(new String(Base64.getMimeDecoder().decode(result.compile_output), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                error.append("(Error decoding compile output: ").append(e.getMessage()).append(")");
            }
        }
        return error.toString();
    }

    private static class Submission {
        private final int language_id;
        private final String source_code;

        Submission(int languageId, String sourceCode) {
            this.language_id = languageId;
            this.source_code = sourceCode;
        }

        public int getLanguage_id() {
            return this.language_id;
        }

        public String getSource_code() {
            return this.source_code;
        }
    }

    private static class SubmissionResult {
        private String stdout;
        private Status status;
        private String compile_output;

        private SubmissionResult() {
        }

        public String getStdout() {
            return this.stdout;
        }

        public void setStdout(String stdout) {
            this.stdout = stdout;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public String getCompile_output() {
            return this.compile_output;
        }

        public void setCompile_output(String compile_output) {
            this.compile_output = compile_output;
        }
    }

    private static class Status {
        private int id;
        private String description;

        private Status() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

