/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.code.azure.acads;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.code.CodeExecutionEngine;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionsREPLTool
implements CodeExecutionEngine {
    private static final String USER_AGENT = "langchain4j-azure-dynamic-sessions";
    private static final String API_VERSION = "2024-02-02-preview";
    private static final Logger log = LoggerFactory.getLogger(SessionsREPLTool.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Map<String, Object>>> LIST_MAP_TYPE_REF = new TypeReference<List<Map<String, Object>>>(){};
    private static final Pattern SANITIZE_PATTERN_START = Pattern.compile("^(\\s|`)*(?i:python)?\\s*");
    private static final Pattern SANITIZE_PATTERN_END = Pattern.compile("(\\s|`)*$");
    private final boolean sanitizeInput;
    private final String poolManagementEndpoint;
    private final String sessionId;
    private final java.net.http.HttpClient nativeHttpClient;
    private final HttpClient langchainHttpClient;
    private final DefaultAzureCredential credential;
    private final AtomicReference<AccessToken> accessTokenRef = new AtomicReference();

    public SessionsREPLTool(String poolManagementEndpoint) {
        this(poolManagementEndpoint, UUID.randomUUID().toString(), true);
    }

    public String execute(String code) {
        return this.use(code);
    }

    public SessionsREPLTool(String poolManagementEndpoint, String sessionId, boolean sanitizeInput) {
        this.poolManagementEndpoint = poolManagementEndpoint;
        this.sessionId = sessionId;
        this.sanitizeInput = sanitizeInput;
        this.nativeHttpClient = java.net.http.HttpClient.newBuilder().build();
        this.langchainHttpClient = HttpClientBuilderLoader.loadHttpClientBuilder().build();
        this.credential = new DefaultAzureCredentialBuilder().build();
    }

    protected SessionsREPLTool(String poolManagementEndpoint, String sessionId, boolean sanitizeInput, HttpClient httpClient, DefaultAzureCredential credential) {
        this.poolManagementEndpoint = poolManagementEndpoint;
        this.sessionId = sessionId;
        this.sanitizeInput = sanitizeInput;
        this.nativeHttpClient = java.net.http.HttpClient.newBuilder().build();
        this.langchainHttpClient = httpClient;
        this.credential = credential;
    }

    @Tool(name="sessions_REPL")
    public String use(String input) {
        Map resultMap;
        Map<String, Object> response = this.executeCode(input);
        Object result = response.get("result");
        if (result instanceof Map && "image".equals((resultMap = (Map)result).get("type")) && resultMap.containsKey("base64_data")) {
            resultMap.remove("base64_data");
        }
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        contentMap.put("result", result);
        contentMap.put("stdout", response.get("stdout"));
        contentMap.put("stderr", response.get("stderr"));
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(contentMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize response.", e);
        }
    }

    public String[] value() {
        return new String[]{"REPL Tool"};
    }

    private String getAccessToken() {
        AccessToken token = this.accessTokenRef.get();
        if (token == null || token.isExpired()) {
            try {
                TokenRequestContext context = new TokenRequestContext().addScopes(new String[]{"https://dynamicsessions.io/.default"});
                token = (AccessToken)this.credential.getToken(context).block();
                if (token == null) {
                    throw new RuntimeException("Failed to acquire access token.");
                }
                this.accessTokenRef.set(token);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to acquire access token.", e);
            }
        }
        return token.getToken();
    }

    private String buildUrl(String path) {
        Object endpoint = this.poolManagementEndpoint;
        if (!((String)endpoint).endsWith("/")) {
            endpoint = (String)endpoint + "/";
        }
        String encodedSessionId = URLEncoder.encode(this.sessionId, StandardCharsets.UTF_8);
        String query = "identifier=" + encodedSessionId + "&api-version=2024-02-02-preview";
        return (String)endpoint + path + "?" + query;
    }

    private String sanitizeInput(String input) {
        input = SANITIZE_PATTERN_START.matcher(input).replaceAll("");
        input = SANITIZE_PATTERN_END.matcher(input).replaceAll("");
        return input;
    }

    public Map<String, Object> executeCode(String sessionCode) {
        if (this.sanitizeInput) {
            sessionCode = this.sanitizeInput(sessionCode);
        }
        String accessToken = this.getAccessToken();
        String apiUrl = this.buildUrl("code/execute");
        HashMap body = new HashMap();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("codeInputType", "inline");
        properties.put("executionType", "synchronous");
        properties.put("code", sessionCode);
        body.put("properties", properties);
        try {
            String requestBody = OBJECT_MAPPER.writeValueAsString(body);
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url(apiUrl).addHeader("Authorization", new String[]{"Bearer " + accessToken}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{USER_AGENT}).body(requestBody).build();
            SuccessfulHttpResponse response = this.langchainHttpClient.execute(request);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Map responseJson = (Map)OBJECT_MAPPER.readValue(response.body(), MAP_TYPE_REF);
                return SessionsREPLTool.getNestedMapProperty(responseJson, "properties");
            }
            throw new RuntimeException("Request failed with status code " + response.statusCode() + ": " + response.body());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute code.", e);
        }
    }

    private static Map<String, Object> getNestedMapProperty(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Map) {
            Map result = (Map)value;
            return result;
        }
        return null;
    }

    public static class RemoteFileMetadata {
        private final String filename;
        private final long sizeInBytes;

        public RemoteFileMetadata(String filename, long sizeInBytes) {
            this.filename = filename;
            this.sizeInBytes = sizeInBytes;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public String getFullPath() {
            return "/mnt/data/" + this.filename;
        }

        public static RemoteFileMetadata fromDict(Map<String, Object> data) {
            Object propertiesObj = data.get("properties");
            if (!(propertiesObj instanceof Map)) {
                throw new IllegalArgumentException("Data does not contain a valid properties map");
            }
            Map properties = (Map)propertiesObj;
            String filename = (String)properties.get("filename");
            Number size = (Number)properties.get("size");
            return new RemoteFileMetadata(filename, size.longValue());
        }
    }

    public class DefaultFileLister
    implements FileLister {
        @Override
        public String listFiles() {
            String accessToken = SessionsREPLTool.this.getAccessToken();
            String apiUrl = SessionsREPLTool.this.buildUrl("files");
            HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url(apiUrl).addHeader("Authorization", new String[]{"Bearer " + accessToken}).build();
            try {
                SuccessfulHttpResponse response = SessionsREPLTool.this.langchainHttpClient.execute(request);
                JsonNode json = OBJECT_MAPPER.readTree(response.body());
                StringBuilder filenames = new StringBuilder();
                JsonNode valueArray = json.get("value");
                if (valueArray.isEmpty()) {
                    return "No files were found at " + apiUrl;
                }
                for (int i = 0; i < valueArray.size(); ++i) {
                    JsonNode currentObject = valueArray.get(i);
                    JsonNode properties = currentObject.get("properties");
                    String filename = properties.get("filename").asText();
                    filenames.append(filename);
                    if (i >= valueArray.size() - 1) continue;
                    filenames.append(", ");
                }
                return filenames.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to list files: " + e.getMessage() + " API URL: " + apiUrl, e);
            }
        }
    }

    public class DefaultFileDownloader
    implements FileDownloader {
        @Override
        public String downloadFile(String remoteFilePath) {
            String accessToken = SessionsREPLTool.this.getAccessToken();
            String apiUrl = SessionsREPLTool.this.buildUrl("files/content/" + remoteFilePath);
            log.debug("Downloading: API URL:" + apiUrl);
            HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url(apiUrl).addHeader("Authorization", new String[]{"Bearer " + accessToken}).build();
            try {
                SuccessfulHttpResponse response = SessionsREPLTool.this.langchainHttpClient.execute(request);
                if (response.statusCode() == 404) {
                    return "File not found: " + remoteFilePath;
                }
                byte[] fileBytes = response.body().getBytes(StandardCharsets.UTF_8);
                return Base64.getEncoder().encodeToString(fileBytes);
            }
            catch (Exception e) {
                if (e.getMessage().contains("404")) {
                    return "File not found: " + remoteFilePath;
                }
                throw new RuntimeException("Failed to download file: " + e.getMessage() + " API URL: " + apiUrl, e);
            }
        }
    }

    public class DefaultFileUploader
    implements FileUploader {
        @Override
        public RemoteFileMetadata uploadFileToAca(Path localFilePath) {
            String remoteFilePath = localFilePath.getFileName().toString();
            log.debug("Found file at local path: " + remoteFilePath);
            String accessToken = SessionsREPLTool.this.getAccessToken();
            String apiUrl = SessionsREPLTool.this.buildUrl("files/upload");
            log.debug("Uploading: API URL:" + apiUrl);
            File file = localFilePath.toFile();
            try {
                String boundary = "----" + System.currentTimeMillis();
                String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"";
                byte[] fileBytes = Files.readAllBytes(localFilePath);
                String separator = "--" + boundary + "\r\n";
                String contentType = "Content-Type: application/json\r\n\r\n";
                String end = "\r\n--" + boundary + "--\r\n";
                byte[] formDataBytes = (separator + contentDisposition + "\r\n" + contentType).getBytes(StandardCharsets.UTF_8);
                byte[] endBytes = end.getBytes(StandardCharsets.UTF_8);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(formDataBytes);
                outputStream.write(fileBytes);
                outputStream.write(endBytes);
                byte[] requestBody = outputStream.toByteArray();
                java.net.http.HttpRequest request = java.net.http.HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Authorization", "Bearer " + accessToken).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
                HttpResponse<String> response = SessionsREPLTool.this.nativeHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() < 200 || response.statusCode() >= 300) {
                    throw new IOException("Unexpected code " + String.valueOf(response));
                }
                Map responseJson = (Map)OBJECT_MAPPER.readValue(response.body(), MAP_TYPE_REF);
                List valueList = (List)OBJECT_MAPPER.convertValue(responseJson.get("value"), LIST_MAP_TYPE_REF);
                Map fileMetadataMap = (Map)valueList.get(0);
                return RemoteFileMetadata.fromDict(fileMetadataMap);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to upload file: " + e.getMessage() + " API URL: " + apiUrl, e);
            }
        }
    }

    public static interface FileLister {
        public String listFiles();
    }

    public static interface FileDownloader {
        public String downloadFile(String var1);
    }

    public static interface FileUploader {
        public RemoteFileMetadata uploadFileToAca(Path var1);
    }
}

