/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.chroma;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.Internal;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class ChromaHttpClient {
    private static final Logger log = LoggerFactory.getLogger(ChromaHttpClient.class);
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final String baseUrl;

    public ChromaHttpClient(String baseUrl, Duration timeout, boolean logRequests, boolean logResponses) {
        this.baseUrl = Utils.ensureTrailingForwardSlash((String)baseUrl);
        HttpClientBuilder httpClientBuilder = HttpClientBuilderLoader.loadHttpClientBuilder();
        if ("dev.langchain4j.http.client.jdk.JdkHttpClientBuilder".equals(httpClientBuilder.getClass().getCanonicalName())) {
            try {
                Method method = httpClientBuilder.getClass().getMethod("httpClientBuilder", HttpClient.Builder.class);
                method.invoke((Object)httpClientBuilder, java.net.http.HttpClient.newBuilder().connectTimeout(timeout).version(HttpClient.Version.HTTP_1_1));
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("Error configuring HTTP 1.1", ex);
            }
        }
        this.httpClient = new LoggingHttpClient(httpClientBuilder.connectTimeout(timeout).readTimeout(timeout).build(), Boolean.valueOf(logRequests), Boolean.valueOf(logResponses));
        this.objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T> T get(String path, Class<T> responseType) throws IOException {
        return this.get(path, responseType, null);
    }

    public <T> T get(String path, Class<T> responseType, Map<String, String> pathParams) throws IOException {
        String url = this.buildUrl(path, pathParams);
        HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url(url).addHeader("Content-Type", new String[]{"application/json"}).build();
        return this.executeRequest(request, responseType);
    }

    public <T> T post(String path, Object requestBody, Class<T> responseType) throws IOException {
        return this.post(path, requestBody, responseType, null);
    }

    public <T> T post(String path, Object requestBody, Class<T> responseType, Map<String, String> pathParams) throws IOException {
        String url = this.buildUrl(path, pathParams);
        String jsonBody = this.objectMapper.writeValueAsString(requestBody);
        HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url(url).addHeader("Content-Type", new String[]{"application/json"}).body(jsonBody).build();
        return this.executeRequest(request, responseType);
    }

    public void delete(String path) throws IOException {
        this.delete(path, null);
    }

    public void delete(String path, Map<String, String> pathParams) throws IOException {
        String url = this.buildUrl(path, pathParams);
        HttpRequest request = HttpRequest.builder().method(HttpMethod.DELETE).url(url).addHeader("Content-Type", new String[]{"application/json"}).build();
        this.executeRequest(request, Void.class);
    }

    private <T> T executeRequest(HttpRequest request, Class<T> responseType) throws IOException {
        try {
            SuccessfulHttpResponse response = this.httpClient.execute(request);
            if (responseType == Void.class || response.body().isEmpty()) {
                return null;
            }
            try {
                return (T)this.objectMapper.readValue(response.body(), responseType);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse response: " + response.body(), e);
            }
        }
        catch (HttpException e) {
            throw new RuntimeException("HTTP error: " + e.getMessage(), e);
        }
    }

    private String buildUrl(String path, Map<String, String> pathParams) {
        Object url = this.baseUrl + path;
        if (pathParams != null) {
            for (Map.Entry<String, String> entry : pathParams.entrySet()) {
                url = ((String)url).replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return url;
    }
}

