/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.memory.chat.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.dtsx.astra.sdk.cassio.ClusteredCassandraTable;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraChatMemoryStore
implements ChatMemoryStore {
    private static final Logger log = LoggerFactory.getLogger(CassandraChatMemoryStore.class);
    public static final String DEFAULT_TABLE_NAME = "message_store";
    private final ClusteredCassandraTable messageTable;

    public CassandraChatMemoryStore(CqlSession session, String keyspaceName, String tableName) {
        this.messageTable = new ClusteredCassandraTable(session, keyspaceName, tableName);
    }

    public CassandraChatMemoryStore(CqlSession session, String keyspaceName) {
        this.messageTable = new ClusteredCassandraTable(session, keyspaceName, DEFAULT_TABLE_NAME);
    }

    public List<ChatMessage> getMessages(@NonNull Object memoryId) {
        if (memoryId == null) {
            throw new NullPointerException("memoryId is marked non-null but is null");
        }
        List<ChatMessage> latestFirstList = this.messageTable.findPartition(this.getMemoryId(memoryId)).stream().map(this::toChatMessage).collect(Collectors.toList());
        Collections.reverse(latestFirstList);
        return latestFirstList;
    }

    public void updateMessages(@NonNull Object memoryId, @NonNull List<ChatMessage> messages) {
        if (memoryId == null) {
            throw new NullPointerException("memoryId is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.deleteMessages(memoryId);
        this.messageTable.upsertPartition(messages.stream().map(record -> this.fromChatMessage(this.getMemoryId(memoryId), (ChatMessage)record)).collect(Collectors.toList()));
    }

    public void deleteMessages(@NonNull Object memoryId) {
        if (memoryId == null) {
            throw new NullPointerException("memoryId is marked non-null but is null");
        }
        this.messageTable.deletePartition(this.getMemoryId(memoryId));
    }

    private ChatMessage toChatMessage(@NonNull ClusteredCassandraTable.Record record) {
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        try {
            return ChatMessageDeserializer.messageFromJson((String)record.getBody());
        }
        catch (Exception e) {
            log.error("Unable to parse message body", (Throwable)e);
            throw new IllegalArgumentException("Unable to parse message body");
        }
    }

    private ClusteredCassandraTable.Record fromChatMessage(@NonNull String memoryId, @NonNull ChatMessage chatMessage) {
        if (memoryId == null) {
            throw new NullPointerException("memoryId is marked non-null but is null");
        }
        if (chatMessage == null) {
            throw new NullPointerException("chatMessage is marked non-null but is null");
        }
        try {
            ClusteredCassandraTable.Record record = new ClusteredCassandraTable.Record();
            record.setRowId(Uuids.timeBased());
            record.setPartitionId(memoryId);
            record.setBody(ChatMessageSerializer.messageToJson((ChatMessage)chatMessage));
            return record;
        }
        catch (Exception e) {
            log.error("Unable to parse message body", (Throwable)e);
            throw new IllegalArgumentException("Unable to parse message body", e);
        }
    }

    private String getMemoryId(Object memoryId) {
        if (!(memoryId instanceof String)) {
            throw new IllegalArgumentException("memoryId must be a String");
        }
        return (String)memoryId;
    }
}

