/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.ToolCallBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.AwsLoggingInterceptor;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.bedrock.BedrockExceptionMapper;
import dev.langchain4j.model.bedrock.ConverseResponseFromStreamBuilder;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ReasoningContentBlockDelta;

public class BedrockStreamingChatModel
extends AbstractBedrockChatModel
implements StreamingChatModel {
    private static final Logger log = LoggerFactory.getLogger(BedrockStreamingChatModel.class);
    private final BedrockRuntimeAsyncClient client;
    private final boolean logResponses;

    public BedrockStreamingChatModel(String modelId) {
        this((Builder)BedrockStreamingChatModel.builder().modelId(modelId));
    }

    public BedrockStreamingChatModel(Builder builder) {
        super(builder);
        this.client = Objects.isNull(builder.client) ? this.createClient((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false)) : builder.client;
        this.logResponses = (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false);
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        BedrockStreamingChatModel.validate(chatRequest.parameters());
        ConverseStreamRequest converseStreamRequest = this.buildConverseStreamRequest(chatRequest);
        ConverseResponseFromStreamBuilder responseBuilder = new ConverseResponseFromStreamBuilder(this.returnThinking);
        ToolCallBuilder toolCallBuilder = new ToolCallBuilder(-1);
        AtomicReference currentContentType = new AtomicReference();
        ConverseStreamResponseHandler converseStreamResponseHandler = ConverseStreamResponseHandler.builder().subscriber(ConverseStreamResponseHandler.Visitor.builder().onMessageStart(event -> {
            if (this.logResponses) {
                log.debug("onMessageStart: {}", event);
            }
            responseBuilder.append((MessageStartEvent)event);
        }).onContentBlockStart(event -> {
            if (this.logResponses) {
                log.debug("onContentBlockStart: {}", event);
            }
            if (event.start().type() == ContentBlockStart.Type.TOOL_USE) {
                toolCallBuilder.updateIndex(Integer.valueOf(toolCallBuilder.index() + 1));
                toolCallBuilder.updateId(event.start().toolUse().toolUseId());
                toolCallBuilder.updateName(event.start().toolUse().name());
            }
            responseBuilder.append((ContentBlockStartEvent)event);
        }).onContentBlockDelta(event -> {
            String input;
            if (this.logResponses) {
                log.debug("onContentBlockDelta: {}", event);
            }
            ContentBlockDelta delta = event.delta();
            currentContentType.set(delta.type());
            if (currentContentType.get() == ContentBlockDelta.Type.TEXT) {
                InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)delta.text());
            } else if (currentContentType.get() == ContentBlockDelta.Type.REASONING_CONTENT) {
                ReasoningContentBlockDelta reasoningContent = delta.reasoningContent();
                String thinking = reasoningContent.text();
                if (Utils.isNotNullOrEmpty((String)thinking)) {
                    InternalStreamingChatResponseHandlerUtils.onPartialThinking((StreamingChatResponseHandler)handler, (String)thinking);
                }
            } else if (currentContentType.get() == ContentBlockDelta.Type.TOOL_USE && Utils.isNotNullOrEmpty((String)(input = delta.toolUse().input()))) {
                toolCallBuilder.appendArguments(input);
            }
            responseBuilder.append(delta);
        }).onContentBlockStop(event -> {
            if (this.logResponses) {
                log.debug("onContentBlockStop: {}", event);
            }
            if (currentContentType.get() == ContentBlockDelta.Type.TOOL_USE) {
                InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)handler, (CompleteToolCall)toolCallBuilder.buildAndReset());
            }
            responseBuilder.append((ContentBlockStopEvent)event);
        }).onMessageStop(event -> {
            if (this.logResponses) {
                log.debug("onMessageStop: {}", event);
            }
            responseBuilder.append((MessageStopEvent)event);
        }).onMetadata(event -> {
            if (this.logResponses) {
                log.debug("onMetadata: {}", event);
            }
            responseBuilder.append((ConverseStreamMetadataEvent)event);
            ChatResponse response = this.responseFrom(responseBuilder.build(), converseStreamRequest.modelId());
            InternalStreamingChatResponseHandlerUtils.onCompleteResponse((StreamingChatResponseHandler)handler, (ChatResponse)response);
        }).build()).build();
        this.client.converseStream(converseStreamRequest, converseStreamResponseHandler).exceptionally(ex -> {
            RuntimeException mappedError = BedrockExceptionMapper.INSTANCE.mapException((Throwable)ex);
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            return null;
        });
    }

    public BedrockChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    private ConverseStreamRequest buildConverseStreamRequest(ChatRequest chatRequest) {
        return (ConverseStreamRequest)ConverseStreamRequest.builder().modelId(chatRequest.modelName()).inferenceConfig(this.inferenceConfigFrom(chatRequest.parameters())).system(this.extractSystemMessages(chatRequest.messages())).messages(this.extractRegularMessages(chatRequest.messages())).toolConfig(this.extractToolConfigurationFrom(chatRequest)).additionalModelRequestFields(this.additionalRequestModelFieldsFrom(chatRequest.parameters())).build();
    }

    private ChatResponse responseFrom(ConverseResponse converseResponse, String modelId) {
        return ChatResponse.builder().aiMessage(this.aiMessageFrom(converseResponse)).metadata(ChatResponseMetadata.builder().id(UUID.randomUUID().toString()).finishReason(this.finishReasonFrom(converseResponse.stopReason())).tokenUsage(this.tokenUsageFrom(converseResponse.usage())).modelName(modelId).build()).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AMAZON_BEDROCK;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BedrockRuntimeAsyncClient createClient(boolean logRequests, boolean logResponses) {
        return (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(config -> {
            config.apiCallTimeout(this.timeout);
            if (logRequests || logResponses) {
                config.addExecutionInterceptor((ExecutionInterceptor)new AwsLoggingInterceptor(logRequests, logResponses));
            }
        })).build();
    }

    public static class Builder
    extends AbstractBedrockChatModel.AbstractBuilder<Builder> {
        private BedrockRuntimeAsyncClient client;

        public Builder client(BedrockRuntimeAsyncClient client) {
            this.client = client;
            return this;
        }

        public BedrockStreamingChatModel build() {
            return new BedrockStreamingChatModel(this);
        }
    }
}

