/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.AwsLoggingInterceptor;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;

public class BedrockChatModel
extends AbstractBedrockChatModel
implements ChatModel {
    private final BedrockRuntimeClient client;

    public BedrockChatModel(String modelId) {
        this((Builder)BedrockChatModel.builder().modelId(modelId));
    }

    private BedrockChatModel(Builder builder) {
        super(builder);
        this.client = Objects.isNull(builder.client) ? this.createClient((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false)) : builder.client;
    }

    public ChatResponse doChat(ChatRequest request) {
        ConverseRequest convRequest = this.buildConverseRequest(request.messages(), request.parameters().toolSpecifications(), request.parameters());
        ConverseResponse response = (ConverseResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.converse(convRequest), (int)this.maxRetries);
        return ChatResponse.builder().aiMessage(this.aiMessageFrom(response)).metadata(ChatResponseMetadata.builder().id(response.responseMetadata().requestId()).finishReason(this.finishReasonFrom(response.stopReason())).tokenUsage(this.tokenUsageFrom(response.usage())).modelName(convRequest.modelId()).build()).build();
    }

    public BedrockChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    private ConverseRequest buildConverseRequest(List<ChatMessage> messages, List<ToolSpecification> toolSpecs, ChatRequestParameters parameters) {
        String model;
        String string = model = Objects.isNull(parameters) || Objects.isNull(parameters.modelName()) ? this.modelId : parameters.modelName();
        if (Objects.nonNull(parameters)) {
            BedrockChatModel.validate(parameters);
        }
        return (ConverseRequest)ConverseRequest.builder().modelId(model).inferenceConfig(this.inferenceConfigurationFrom(parameters)).system(this.extractSystemMessages(messages)).messages(this.extractRegularMessages(messages)).toolConfig(this.extractToolConfigurationFrom(toolSpecs, parameters)).additionalModelRequestFields(this.additionalRequestModelFieldsFrom(parameters)).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AMAZON_BEDROCK;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BedrockRuntimeClient createClient(boolean logRequests, boolean logResponses) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(config -> {
            config.apiCallTimeout(this.timeout);
            if (logRequests || logResponses) {
                config.addExecutionInterceptor((ExecutionInterceptor)new AwsLoggingInterceptor(logRequests, logResponses));
            }
        })).build();
    }

    public static class Builder
    extends AbstractBedrockChatModel.AbstractBuilder<Builder> {
        private BedrockRuntimeClient client;

        public Builder client(BedrockRuntimeClient client) {
            this.client = client;
            return this;
        }

        public BedrockChatModel build() {
            return new BedrockChatModel(this);
        }
    }
}

