/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.internal.AbstractSharedBedrockChatModel;
import dev.langchain4j.model.bedrock.internal.BedrockChatModelResponse;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ChatRequestValidator;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.Response;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public abstract class AbstractBedrockChatModel<T extends BedrockChatModelResponse>
extends AbstractSharedBedrockChatModel
implements ChatLanguageModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBedrockChatModel.class);
    private volatile BedrockRuntimeClient client;

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestValidator.validateMessages((List)chatRequest.messages());
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidator.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidator.validate((List)parameters.toolSpecifications());
        ChatRequestValidator.validate((ToolChoice)parameters.toolChoice());
        ChatRequestValidator.validate((ResponseFormat)parameters.responseFormat());
        Response<AiMessage> response = this.generate(chatRequest.messages());
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    protected Response<AiMessage> generate(List<ChatMessage> messages) {
        String body = this.convertMessagesToAwsBody(messages);
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        ChatModelRequest modelListenerRequest = this.createModelListenerRequest(invokeModelRequest, messages, Collections.emptyList());
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            InvokeModelResponse invokeModelResponse = (InvokeModelResponse)RetryUtils.withRetryMappingExceptions(() -> this.getClient().invokeModel(invokeModelRequest), (int)this.maxRetries);
            String response = invokeModelResponse.body().asUtf8String();
            BedrockChatModelResponse result = (BedrockChatModelResponse)Json.fromJson(response, this.getResponseClassType());
            Response<AiMessage> responseMessage = this.toAiMessage(result);
            ChatModelResponse modelListenerResponse = this.createModelListenerResponse(null, null, responseMessage);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return responseMessage;
        }
        catch (RuntimeException e) {
            this.listenerErrorResponse(e, modelListenerRequest, this.provider(), attributes);
            throw e;
        }
    }

    public Response<AiMessage> toAiMessage(T result) {
        return new Response((Object)new AiMessage(result.getOutputText()), result.getTokenUsage(), result.getFinishReason());
    }

    @Override
    protected abstract Map<String, Object> getRequestParameters(String var1);

    protected abstract Class<T> getResponseClassType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockRuntimeClient getClient() {
        if (this.client == null) {
            AbstractBedrockChatModel abstractBedrockChatModel = this;
            synchronized (abstractBedrockChatModel) {
                if (this.client == null) {
                    this.client = this.initClient();
                }
            }
        }
        return this.client;
    }

    protected static Map<String, Object> of(final String key, final Object value) {
        return new HashMap<String, Object>(1){
            {
                super(arg0);
                this.put(key, value);
            }
        };
    }

    private BedrockRuntimeClient initClient() {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(this.timeout))).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AMAZON_BEDROCK;
    }

    @Generated
    protected AbstractBedrockChatModel(AbstractBedrockChatModelBuilder<T, ?, ?> b) {
        super(b);
        this.client = b.client;
    }

    @Generated
    public static abstract class AbstractBedrockChatModelBuilder<T extends BedrockChatModelResponse, C extends AbstractBedrockChatModel<T>, B extends AbstractBedrockChatModelBuilder<T, C, B>>
    extends AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder<C, B> {
        @Generated
        private BedrockRuntimeClient client;

        @Generated
        public B client(BedrockRuntimeClient client) {
            this.client = client;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractBedrockChatModel.AbstractBedrockChatModelBuilder(super=" + super.toString() + ", client=" + String.valueOf(this.client) + ")";
        }
    }
}

