/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.bedrock.internal.AbstractSharedBedrockChatModel;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;

public abstract class AbstractBedrockStreamingChatModel
extends AbstractSharedBedrockChatModel
implements StreamingChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractBedrockStreamingChatModel.class);
    private final BedrockRuntimeAsyncClient asyncClient = this.initAsyncClient();

    public void generate(String userMessage, StreamingResponseHandler<AiMessage> handler) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add((ChatMessage)new UserMessage(userMessage));
        this.generate(messages, handler);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        InvokeModelWithResponseStreamRequest request = (InvokeModelWithResponseStreamRequest)InvokeModelWithResponseStreamRequest.builder().body(SdkBytes.fromUtf8String((String)this.convertMessagesToAwsBody(messages))).modelId(this.getModelId()).contentType("application/json").accept("application/json").build();
        ChatModelRequest modelListenerRequest = this.createModelListenerRequest(request, messages, Collections.emptyList());
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        StringBuffer finalCompletion = new StringBuffer();
        InvokeModelWithResponseStreamResponseHandler.Visitor visitor = InvokeModelWithResponseStreamResponseHandler.Visitor.builder().onChunk(chunk -> {
            StreamingResponse sr = Json.fromJson(chunk.bytes().asUtf8String(), StreamingResponse.class);
            finalCompletion.append(sr.completion);
            handler.onNext(sr.completion);
        }).build();
        InvokeModelWithResponseStreamResponseHandler h = ((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)InvokeModelWithResponseStreamResponseHandler.builder().onEventStream(stream -> stream.subscribe(event -> event.accept(visitor)))).onComplete(() -> {
            Response response = Response.from((Object)new AiMessage(finalCompletion.toString()));
            ChatModelResponse modelListenerResponse = this.createModelListenerResponse(null, null, (Response<AiMessage>)response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            handler.onComplete(response);
        })).onError(throwable -> {
            this.listenerErrorResponse((Throwable)throwable, modelListenerRequest, attributes);
            handler.onError(throwable);
        })).build();
        try {
            this.asyncClient.invokeModelWithResponseStream(request, h).join();
        }
        catch (RuntimeException e) {
            log.error("Error on bedrock stream request", (Throwable)e);
        }
    }

    private BedrockRuntimeAsyncClient initAsyncClient() {
        BedrockRuntimeAsyncClient client = (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(this.timeout))).build();
        return client;
    }

    protected AbstractBedrockStreamingChatModel(AbstractBedrockStreamingChatModelBuilder<?, ?> b) {
        super(b);
    }

    public BedrockRuntimeAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    static class StreamingResponse {
        public String completion;

        StreamingResponse() {
        }
    }

    public static abstract class AbstractBedrockStreamingChatModelBuilder<C extends AbstractBedrockStreamingChatModel, B extends AbstractBedrockStreamingChatModelBuilder<C, B>>
    extends AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AbstractBedrockStreamingChatModel.AbstractBedrockStreamingChatModelBuilder(super=" + super.toString() + ")";
        }
    }
}

