/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.a2a;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.a2a.A2AClientSpecification;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.scope.AgenticScope;
import io.a2a.spec.AgentCard;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;

public class A2AClientAgentInvoker
implements AgentInvoker {
    private final String[] inputNames;
    private final String outputName;
    private final boolean async;
    private final AgentCard agentCard;
    private final Method method;

    public A2AClientAgentInvoker(A2AClientSpecification a2AClientInstance, Method method) {
        this.method = method;
        this.agentCard = a2AClientInstance.agentCard();
        this.inputNames = this.inputNames(a2AClientInstance);
        this.outputName = a2AClientInstance.outputName();
        this.async = a2AClientInstance.async();
    }

    private String[] inputNames(A2AClientSpecification a2AClientInstance) {
        return this.isUntyped() ? a2AClientInstance.inputNames() : (String[])Stream.of(this.method.getParameters()).map(AgentInvoker::parameterName).toArray(String[]::new);
    }

    public String name() {
        return this.agentCard.name();
    }

    public String description() {
        return this.agentCard.description();
    }

    public String outputName() {
        return this.outputName;
    }

    public boolean async() {
        return this.async;
    }

    public Method method() {
        return this.method;
    }

    public String toCard() {
        return "{" + this.name() + ": " + this.description() + ", " + Arrays.toString(this.inputNames) + "}";
    }

    public Object[] toInvocationArguments(AgenticScope agenticScope) {
        Object[] objectArray;
        if (this.isUntyped()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = agenticScope.state();
        } else {
            objectArray = Stream.of(this.inputNames).map(arg_0 -> ((AgenticScope)agenticScope).readState(arg_0)).toArray();
        }
        return objectArray;
    }

    private boolean isUntyped() {
        return this.method.getDeclaringClass() == UntypedAgent.class;
    }
}

