/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph.graph;

import dev.iurysouza.modulegraph.LinkText;
import dev.iurysouza.modulegraph.ModuleType;
import dev.iurysouza.modulegraph.gradle.Module;
import dev.iurysouza.modulegraph.graph.DigraphModel;
import dev.iurysouza.modulegraph.graph.ExtKt;
import dev.iurysouza.modulegraph.graph.ModuleConfig;
import dev.iurysouza.modulegraph.graph.ModuleNode;
import dev.iurysouza.modulegraph.model.GraphConfig;
import dev.iurysouza.modulegraph.model.GraphParseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J \u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Ldev/iurysouza/modulegraph/graph/DigraphBuilder;", "", "()V", "build", "", "Ldev/iurysouza/modulegraph/graph/DigraphModel;", "graphResult", "Ldev/iurysouza/modulegraph/model/GraphParseResult;", "buildModel", "config", "Ldev/iurysouza/modulegraph/model/GraphConfig;", "source", "Ldev/iurysouza/modulegraph/gradle/Module;", "target", "throwIfNothingMatches", "", "modelList", "regex", "", "verifySufficientGraph", "getParent", "modulegraph"})
@SourceDebugExtension(value={"SMAP\nDigraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigraphBuilder.kt\ndev/iurysouza/modulegraph/graph/DigraphBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n76#2:105\n96#2,2:106\n98#2,3:129\n1655#3,8:108\n1603#3,9:116\n1855#3:125\n1856#3:127\n1612#3:128\n1655#3,8:133\n1#4:126\n1#4:132\n*S KotlinDebug\n*F\n+ 1 DigraphBuilder.kt\ndev/iurysouza/modulegraph/graph/DigraphBuilder\n*L\n16#1:105\n16#1:106,2\n16#1:129,3\n18#1:108,8\n20#1:116,9\n20#1:125\n20#1:127\n20#1:128\n84#1:133,8\n20#1:126\n*E\n"})
public final class DigraphBuilder {
    @NotNull
    public static final DigraphBuilder INSTANCE = new DigraphBuilder();

    private DigraphBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DigraphModel> build(@NotNull GraphParseResult graphResult) {
        List list;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)graphResult, (String)"graphResult");
        Map<Module, List<Module>> graphModel = graphResult.getGraph();
        GraphConfig config = graphResult.getConfig();
        this.verifySufficientGraph(graphResult);
        Map<Module, List<Module>> $this$flatMap$iv = graphModel;
        boolean $i$f$flatMap = false;
        Map<Module, List<Module>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List list2;
            Iterable $this$distinctBy$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Module source = (Module)entry.getKey();
            List targetList = (List)entry.getValue();
            if (WhenMappings.$EnumSwitchMapping$0[config.getLinkText().ordinal()] == 1) {
                $this$distinctBy$iv = targetList;
                boolean $i$f$distinctBy = false;
                HashSet<String> set$iv = new HashSet<String>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    Module it = (Module)e$iv;
                    boolean bl2 = false;
                    String key$iv = it.getPath();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                list2 = list$iv;
            } else {
                list2 = targetList;
            }
            Iterable iterable = list2;
            boolean $i$f$mapNotNull = false;
            $this$distinctBy$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DigraphModel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                Module target = (Module)element$iv$iv2;
                boolean bl4 = false;
                if (INSTANCE.buildModel(config, source, target) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List result = list = (List)destination$iv$iv;
        boolean bl = false;
        INSTANCE.throwIfNothingMatches(result, config.getFocusedModulesRegex());
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final DigraphModel buildModel(GraphConfig config, Module source, Module target) {
        DigraphModel digraphModel;
        Pair pair;
        Regex regex;
        String string = config.getFocusedModulesRegex();
        if (string != null) {
            String it = string;
            boolean bl = false;
            regex = new Regex(it);
        } else {
            regex = null;
        }
        Regex focusedModulesRegex = regex;
        boolean showFullPath = config.getShowFullPath();
        Module module = target;
        String targetFullName = module != null ? module.getPath() : null;
        String sourceFullName = source.getPath();
        if (focusedModulesRegex == null) {
            pair = TuplesKt.to((Object)true, (Object)true);
        } else {
            String string2 = targetFullName;
            boolean match = string2 != null ? focusedModulesRegex.matches((CharSequence)string2) : false;
            pair = TuplesKt.to((Object)focusedModulesRegex.matches((CharSequence)sourceFullName), (Object)match);
        }
        Pair pair2 = pair;
        boolean sourceMatches = (Boolean)pair2.component1();
        boolean targetMatches = (Boolean)pair2.component2();
        boolean isFocusedModulesRegexSet = focusedModulesRegex != null;
        boolean shouldNotAddToGraph = Intrinsics.areEqual((Object)sourceFullName, (Object)targetFullName) || !sourceMatches && !targetMatches;
        if (shouldNotAddToGraph) {
            digraphModel = null;
        } else {
            String string3;
            String string4 = ExtKt.getProjectName(sourceFullName, showFullPath);
            boolean bl = sourceMatches && isFocusedModulesRegexSet;
            String string5 = ModuleConfig.Companion.none-hgsYCjQ();
            ModuleType moduleType = source.getType();
            String string6 = this.getParent(sourceFullName);
            ModuleNode moduleNode = new ModuleNode(string4, bl, sourceFullName, string5, moduleType, string6, null);
            String string7 = targetFullName;
            Intrinsics.checkNotNull((Object)string7);
            string4 = ExtKt.getProjectName(string7, showFullPath);
            bl = targetMatches && isFocusedModulesRegexSet;
            String string8 = target.getConfigName();
            if (string8 != null) {
                void it;
                String string9 = string8;
                ModuleNode moduleNode2 = moduleNode;
                boolean bl2 = false;
                string3 = ModuleConfig.constructor-impl((String)it);
                moduleNode = moduleNode2;
            } else {
                string3 = ModuleConfig.Companion.none-hgsYCjQ();
            }
            string5 = string3;
            moduleType = target.getType();
            string6 = this.getParent(targetFullName);
            ModuleNode moduleNode3 = new ModuleNode(string4, bl, targetFullName, string5, moduleType, string6, null);
            ModuleNode moduleNode4 = moduleNode;
            digraphModel = new DigraphModel(moduleNode4, moduleNode3);
        }
        return digraphModel;
    }

    static /* synthetic */ DigraphModel buildModel$default(DigraphBuilder digraphBuilder, GraphConfig graphConfig, Module module, Module module2, int n, Object object) {
        if ((n & 4) != 0) {
            module2 = null;
        }
        return digraphBuilder.buildModel(graphConfig, module, module2);
    }

    private final void throwIfNothingMatches(List<DigraphModel> modelList, String regex) {
        if (!(!((Collection)modelList).isEmpty())) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default((String)("\n                    |No modules match the specified pattern: " + regex + "\n                    |This was set via the `focusedModulesRegex` property.\n            "), null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void verifySufficientGraph(GraphParseResult graphResult) {
        Map<Module, List<Module>> graphModel = graphResult.getGraph();
        GraphConfig config = graphResult.getConfig();
        Iterable $this$distinctBy$iv = CollectionsKt.flatten((Iterable)graphModel.values());
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Module it = (Module)e$iv;
            boolean bl = false;
            String key$iv = it.getPath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        int dependencies = ((List)list$iv).size();
        if (!(graphModel.keySet().size() > 1 || dependencies > 0)) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default((String)("\n                    |The project must have at least two modules to generate a graph.\n                    |It may be that the config is too restrictive: " + config + "\n            "), null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String getParent(String $this$getParent) {
        String[] stringArray = new String[]{":"};
        List groups = StringsKt.split$default((CharSequence)$this$getParent, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (groups.size() == 1) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)groups, (int)1), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LinkText.values().length];
            try {
                nArray[LinkText.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

