/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class AllOfEvaluator
implements Evaluator {
    private final List<CompoundUri> refs;

    AllOfEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.refs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        ArrayList<Integer> unmatchedIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.refs.size(); ++i) {
            if (ctx.resolveInternalRefAndValidate(this.refs.get(i), node)) continue;
            unmatchedIndexes.add(i);
        }
        if (unmatchedIndexes.isEmpty()) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(() -> String.format("Value does not match against the schemas at indexes %s", unmatchedIndexes));
    }
}

