/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.InvalidSchemaException;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaData;
import dev.harrel.jsonschema.MetaSchemaResolvingException;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Validator;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

class MetaSchemaValidator {
    private final JsonNodeFactory jsonNodeFactory;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;

    MetaSchemaValidator(JsonNodeFactory jsonNodeFactory, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    MetaSchemaData validateSchema(JsonParser jsonParser, URI metaSchemaUri, String schemaUri, JsonNode node) {
        Objects.requireNonNull(metaSchemaUri);
        Schema schema = this.resolveMetaSchema(jsonParser, metaSchemaUri);
        EvaluationContext ctx = new EvaluationContext(this.jsonNodeFactory, jsonParser, this.schemaRegistry, this.schemaResolver);
        if (!ctx.validateAgainstSchema(schema, node)) {
            throw new InvalidSchemaException(String.format("Schema [%s] failed to validate against meta-schema [%s]", schemaUri, metaSchemaUri), new Validator.Result(false, ctx).getErrors());
        }
        return schema.getMetaValidationData();
    }

    private Schema resolveMetaSchema(JsonParser jsonParser, URI uri) {
        CompoundUri compoundUri = CompoundUri.fromString(uri.toString());
        return OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(compoundUri)), () -> Optional.ofNullable(this.schemaRegistry.getDynamic(compoundUri))).orElseGet(() -> this.resolveExternalSchema(jsonParser, uri));
    }

    private Schema resolveExternalSchema(JsonParser jsonParser, URI uri) {
        URI baseUri = UriUtil.getUriWithoutFragment(uri);
        if (this.schemaRegistry.get(baseUri) != null) {
            throw MetaSchemaResolvingException.resolvingFailure(uri.toString());
        }
        SchemaResolver.Result result = this.schemaResolver.resolve(baseUri.toString());
        if (result.isEmpty()) {
            throw MetaSchemaResolvingException.resolvingFailure(uri.toString());
        }
        try {
            result.toJsonNode(this.jsonNodeFactory).ifPresent(node -> jsonParser.parseRootSchema(baseUri, (JsonNode)node));
        }
        catch (Exception e) {
            throw MetaSchemaResolvingException.parsingFailure(uri.toString(), e);
        }
        return this.resolveMetaSchema(jsonParser, uri);
    }
}

