/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AnnotationTree {
    private final Map<String, Node> lookupMap = new HashMap<String, Node>();

    AnnotationTree() {
        this.lookupMap.put(null, new Node());
    }

    List<Annotation> getAllAnnotations() {
        return this.lookupMap.get(null).toList();
    }

    Node getNode(String location) {
        return this.lookupMap.get(location);
    }

    Node createIfAbsent(String parentLocation, String location) {
        return this.lookupMap.computeIfAbsent(location, key -> {
            Node node = new Node();
            this.lookupMap.get((Object)parentLocation).nodes.add(node);
            return node;
        });
    }

    static class Node {
        final List<Node> nodes = new ArrayList<Node>();
        final List<Annotation> annotations = new ArrayList<Annotation>();

        Node() {
        }

        List<Annotation> toList() {
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Node node : this.nodes) {
                result.addAll(node.toList());
            }
            result.addAll(this.annotations);
            return result;
        }
    }
}

