/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.AdditionalPropertiesEvaluator;
import dev.harrel.jsonschema.AllOfEvaluator;
import dev.harrel.jsonschema.AnyOfEvaluator;
import dev.harrel.jsonschema.ConstEvaluator;
import dev.harrel.jsonschema.ContainsEvaluator;
import dev.harrel.jsonschema.DependentRequiredEvaluator;
import dev.harrel.jsonschema.DependentSchemasEvaluator;
import dev.harrel.jsonschema.EnumEvaluator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.ExclusiveMaximumEvaluator;
import dev.harrel.jsonschema.ExclusiveMinimumEvaluator;
import dev.harrel.jsonschema.IfThenElseEvaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MaxContainsEvaluator;
import dev.harrel.jsonschema.MaxItemsEvaluator;
import dev.harrel.jsonschema.MaxLengthEvaluator;
import dev.harrel.jsonschema.MaxPropertiesEvaluator;
import dev.harrel.jsonschema.MaximumEvaluator;
import dev.harrel.jsonschema.MinContainsEvaluator;
import dev.harrel.jsonschema.MinItemsEvaluator;
import dev.harrel.jsonschema.MinLengthEvaluator;
import dev.harrel.jsonschema.MinPropertiesEvaluator;
import dev.harrel.jsonschema.MinimumEvaluator;
import dev.harrel.jsonschema.MultipleOfEvaluator;
import dev.harrel.jsonschema.NotEvaluator;
import dev.harrel.jsonschema.OneOfEvaluator;
import dev.harrel.jsonschema.PatternEvaluator;
import dev.harrel.jsonschema.PatternPropertiesEvaluator;
import dev.harrel.jsonschema.PropertiesEvaluator;
import dev.harrel.jsonschema.PropertyNamesEvaluator;
import dev.harrel.jsonschema.RefEvaluator;
import dev.harrel.jsonschema.RequiredEvaluator;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.TypeEvaluator;
import dev.harrel.jsonschema.UnevaluatedItemsEvaluator;
import dev.harrel.jsonschema.UnevaluatedPropertiesEvaluator;
import dev.harrel.jsonschema.UniqueItemsEvaluator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

abstract class AbstractEvaluatorFactory
implements EvaluatorFactory {
    private final Set<String> ignoredKeywords;
    private final Map<String, EvaluatorInfo> evaluatorsMap;

    AbstractEvaluatorFactory(Set<String> ignoredKeywords, Map<String, EvaluatorInfo> evaluatorsMap) {
        this.ignoredKeywords = Collections.unmodifiableSet(ignoredKeywords);
        this.evaluatorsMap = Collections.unmodifiableMap(evaluatorsMap);
    }

    @Override
    public Optional<Evaluator> create(SchemaParsingContext ctx, String fieldName, JsonNode node) {
        if (this.ignoredKeywords.contains(fieldName)) {
            return Optional.empty();
        }
        EvaluatorInfo evaluatorInfo = this.evaluatorsMap.get(fieldName);
        if (evaluatorInfo == null) {
            if (node.isString()) {
                return Optional.of(new AnnotationEvaluator(node.asString()));
            }
            return Optional.empty();
        }
        if (evaluatorInfo.vocabulary != null && !ctx.getMetaValidationData().activeVocabularies.contains(evaluatorInfo.vocabulary)) {
            return Optional.empty();
        }
        try {
            return Optional.of(evaluatorInfo.creator.apply(ctx, node));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static Map<String, EvaluatorInfo> createDefaultEvaluatorsMap(String coreVocab, String applicatorVocab, String unevaluatedVocab, String validationVocab) {
        HashMap<String, EvaluatorInfo> map = new HashMap<String, EvaluatorInfo>();
        map.put("$ref", new EvaluatorInfo(coreVocab, RefEvaluator::new));
        map.put("type", new EvaluatorInfo(validationVocab, (ctx, node) -> new TypeEvaluator((JsonNode)node)));
        map.put("const", new EvaluatorInfo(validationVocab, (ctx, node) -> new ConstEvaluator((JsonNode)node)));
        map.put("enum", new EvaluatorInfo(validationVocab, (ctx, node) -> new EnumEvaluator((JsonNode)node)));
        map.put("multipleOf", new EvaluatorInfo(validationVocab, (ctx, node) -> new MultipleOfEvaluator((JsonNode)node)));
        map.put("maximum", new EvaluatorInfo(validationVocab, (ctx, node) -> new MaximumEvaluator((JsonNode)node)));
        map.put("exclusiveMaximum", new EvaluatorInfo(validationVocab, (ctx, node) -> new ExclusiveMaximumEvaluator((JsonNode)node)));
        map.put("minimum", new EvaluatorInfo(validationVocab, (ctx, node) -> new MinimumEvaluator((JsonNode)node)));
        map.put("exclusiveMinimum", new EvaluatorInfo(validationVocab, (ctx, node) -> new ExclusiveMinimumEvaluator((JsonNode)node)));
        map.put("maxLength", new EvaluatorInfo(validationVocab, (ctx, node) -> new MaxLengthEvaluator((JsonNode)node)));
        map.put("minLength", new EvaluatorInfo(validationVocab, (ctx, node) -> new MinLengthEvaluator((JsonNode)node)));
        map.put("pattern", new EvaluatorInfo(validationVocab, (ctx, node) -> new PatternEvaluator((JsonNode)node)));
        map.put("maxItems", new EvaluatorInfo(validationVocab, (ctx, node) -> new MaxItemsEvaluator((JsonNode)node)));
        map.put("minItems", new EvaluatorInfo(validationVocab, (ctx, node) -> new MinItemsEvaluator((JsonNode)node)));
        map.put("uniqueItems", new EvaluatorInfo(validationVocab, (ctx, node) -> new UniqueItemsEvaluator((JsonNode)node)));
        map.put("maxContains", new EvaluatorInfo(validationVocab, (ctx, node) -> new MaxContainsEvaluator((JsonNode)node)));
        map.put("minContains", new EvaluatorInfo(validationVocab, (ctx, node) -> new MinContainsEvaluator((JsonNode)node)));
        map.put("maxProperties", new EvaluatorInfo(validationVocab, (ctx, node) -> new MaxPropertiesEvaluator((JsonNode)node)));
        map.put("minProperties", new EvaluatorInfo(validationVocab, (ctx, node) -> new MinPropertiesEvaluator((JsonNode)node)));
        map.put("required", new EvaluatorInfo(validationVocab, (ctx, node) -> new RequiredEvaluator((JsonNode)node)));
        map.put("dependentRequired", new EvaluatorInfo(validationVocab, (ctx, node) -> new DependentRequiredEvaluator((JsonNode)node)));
        map.put("contains", new EvaluatorInfo(applicatorVocab, ContainsEvaluator::new));
        map.put("additionalProperties", new EvaluatorInfo(applicatorVocab, AdditionalPropertiesEvaluator::new));
        map.put("properties", new EvaluatorInfo(applicatorVocab, PropertiesEvaluator::new));
        map.put("patternProperties", new EvaluatorInfo(applicatorVocab, PatternPropertiesEvaluator::new));
        map.put("dependentSchemas", new EvaluatorInfo(applicatorVocab, DependentSchemasEvaluator::new));
        map.put("propertyNames", new EvaluatorInfo(applicatorVocab, PropertyNamesEvaluator::new));
        map.put("if", new EvaluatorInfo(applicatorVocab, IfThenElseEvaluator::new));
        map.put("allOf", new EvaluatorInfo(applicatorVocab, AllOfEvaluator::new));
        map.put("anyOf", new EvaluatorInfo(applicatorVocab, AnyOfEvaluator::new));
        map.put("oneOf", new EvaluatorInfo(applicatorVocab, OneOfEvaluator::new));
        map.put("not", new EvaluatorInfo(applicatorVocab, NotEvaluator::new));
        map.put("unevaluatedItems", new EvaluatorInfo(unevaluatedVocab, UnevaluatedItemsEvaluator::new));
        map.put("unevaluatedProperties", new EvaluatorInfo(unevaluatedVocab, UnevaluatedPropertiesEvaluator::new));
        return map;
    }

    static class EvaluatorInfo {
        final String vocabulary;
        final BiFunction<SchemaParsingContext, JsonNode, Evaluator> creator;

        EvaluatorInfo(String vocabulary, BiFunction<SchemaParsingContext, JsonNode, Evaluator> creator) {
            this.vocabulary = vocabulary;
            this.creator = creator;
        }
    }

    static class AnnotationEvaluator
    implements Evaluator {
        private final String annotation;

        public AnnotationEvaluator(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
            return Evaluator.Result.success(this.annotation);
        }
    }
}

