/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum SimpleType {
    NULL("null"),
    BOOLEAN("boolean"),
    STRING("string"),
    INTEGER("integer"),
    NUMBER("number"),
    ARRAY("array"),
    OBJECT("object");

    private static final Map<String, SimpleType> NAME_MAP;
    private final String name;

    private SimpleType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SimpleType fromName(String name) {
        return NAME_MAP.get(name);
    }

    static {
        HashMap<String, SimpleType> map = new HashMap<String, SimpleType>();
        for (SimpleType value : SimpleType.values()) {
            map.put(value.getName(), value);
        }
        NAME_MAP = Collections.unmodifiableMap(map);
    }
}

