/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MetaSchemaData;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SpecificationVersion;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public final class SchemaParsingContext {
    private final MetaSchemaData metaSchemaData;
    private final URI baseUri;
    private final URI parentUri;
    private final SchemaRegistry schemaRegistry;
    private final Map<String, JsonNode> currentSchemaObject;

    private SchemaParsingContext(MetaSchemaData metaSchemaData, URI baseUri, URI parentUri, SchemaRegistry schemaRegistry, Map<String, JsonNode> currentSchemaObject) {
        this.metaSchemaData = metaSchemaData;
        this.baseUri = baseUri;
        this.parentUri = parentUri;
        this.schemaRegistry = schemaRegistry;
        this.currentSchemaObject = currentSchemaObject;
    }

    SchemaParsingContext(MetaSchemaData metaSchemaData, SchemaRegistry schemaRegistry, URI baseUri, Map<String, JsonNode> currentSchemaObject) {
        this(metaSchemaData, baseUri, baseUri, schemaRegistry, currentSchemaObject);
    }

    SchemaParsingContext forChild(MetaSchemaData metaSchemaData, Map<String, JsonNode> currentSchemaObject, URI parentUri) {
        return new SchemaParsingContext(metaSchemaData, this.baseUri, parentUri, this.schemaRegistry, currentSchemaObject);
    }

    SchemaParsingContext forChild(Map<String, JsonNode> currentSchemaObject) {
        return this.forChild(this.metaSchemaData, currentSchemaObject, this.parentUri);
    }

    MetaSchemaData getMetaValidationData() {
        return this.metaSchemaData;
    }

    SpecificationVersion getSpecificationVersion() {
        return this.metaSchemaData.dialect.getSpecificationVersion();
    }

    URI getBaseUri() {
        return this.baseUri;
    }

    public URI getParentUri() {
        return this.parentUri;
    }

    public String getAbsoluteUri(JsonNode node) {
        return this.getAbsoluteUri(node.getJsonPointer());
    }

    public String getAbsoluteUri(String jsonPointer) {
        return this.baseUri + "#" + jsonPointer;
    }

    public Map<String, JsonNode> getCurrentSchemaObject() {
        return Collections.unmodifiableMap(this.currentSchemaObject);
    }

    CompoundUri getCompoundUri(JsonNode node) {
        return new CompoundUri(this.baseUri, node.getJsonPointer());
    }
}

