/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class PrefixItemsEvaluator
implements Evaluator {
    private final List<CompoundUri> prefixRefs;

    PrefixItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.prefixRefs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> elements = node.asArray();
        int size = Math.min(this.prefixRefs.size(), elements.size());
        boolean valid = true;
        for (int i = 0; i < size; ++i) {
            valid = ctx.resolveInternalRefAndValidate(this.prefixRefs.get(i), elements.get(i)) && valid;
        }
        return valid ? Evaluator.Result.success(this.prefixRefs.size()) : Evaluator.Result.failure();
    }
}

