/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.AbstractEvaluatorFactory;
import dev.harrel.jsonschema.AdditionalItemsEvaluator;
import dev.harrel.jsonschema.ItemsLegacyEvaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.RecursiveRefEvaluator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Draft2019EvaluatorFactory
extends AbstractEvaluatorFactory {
    public Draft2019EvaluatorFactory() {
        super(Draft2019EvaluatorFactory.getIgnoredKeywords(), Draft2019EvaluatorFactory.createEvaluatorMap());
    }

    private static Set<String> getIgnoredKeywords() {
        return new HashSet<String>(Arrays.asList("$id", "$schema", "$anchor", "$recursiveAnchor", "$vocabulary", "$comment", "$defs", "then", "else"));
    }

    private static Map<String, AbstractEvaluatorFactory.EvaluatorInfo> createEvaluatorMap() {
        Map<String, AbstractEvaluatorFactory.EvaluatorInfo> map = Draft2019EvaluatorFactory.createDefaultEvaluatorsMap("https://json-schema.org/draft/2019-09/vocab/core", "https://json-schema.org/draft/2019-09/vocab/applicator", "https://json-schema.org/draft/2019-09/vocab/applicator", "https://json-schema.org/draft/2019-09/vocab/validation");
        map.put("$recursiveRef", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2019-09/vocab/core", (ctx, node) -> new RecursiveRefEvaluator((JsonNode)node)));
        map.put("items", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2019-09/vocab/applicator", ItemsLegacyEvaluator::new));
        map.put("additionalItems", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2019-09/vocab/applicator", AdditionalItemsEvaluator::new));
        return map;
    }
}

