/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.DependentRequiredEvaluator;
import dev.harrel.jsonschema.DependentSchemasEvaluator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Map;
import java.util.stream.Collectors;

class DependenciesLegacyEvaluator
implements Evaluator {
    private final DependentRequiredEvaluator requiredDelegate;
    private final DependentSchemasEvaluator schemasDelegate;

    DependenciesLegacyEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        Map<Boolean, Map<String, JsonNode>> splitMap = node.asObject().entrySet().stream().collect(Collectors.partitioningBy(entry -> ((JsonNode)entry.getValue()).isArray(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.requiredDelegate = new DependentRequiredEvaluator(splitMap.get(true));
        this.schemasDelegate = new DependentSchemasEvaluator(ctx, splitMap.get(false));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        Evaluator.Result result = this.requiredDelegate.evaluate(ctx, node);
        if (!result.isValid()) {
            return result;
        }
        return this.schemasDelegate.evaluate(ctx, node);
    }
}

