/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.workers.internal

import org.gradle.integtests.fixtures.AbstractIntegrationSpec
import org.gradle.integtests.fixtures.Sample
import org.gradle.test.fixtures.file.TestFile
import org.junit.Rule
import spock.lang.Unroll


abstract class AbstractWorkerExecutorSampleIntegrationTest extends AbstractIntegrationSpec {
    abstract String getSampleName()

    List<String> getDsls() {
        ['groovy', 'kotlin']
    }

    @Rule
    Sample sampleProvider = new Sample(testDirectoryProvider, sampleName)

    TestFile workerExecutorSample(String dsl) {
        sampleProvider.dir.file(dsl)
    }

    @Unroll
    def "creates expected content (#dsl)"() {
        when:
        executer.inDirectory(workerExecutorSample(dsl))
        succeeds "reverseFiles"

        then:
        assertReversedFilesArePresentAndCorrect(dsl)

        and:
        assertSampleSpecificOutcome(dsl)

        where:
        dsl << getDsls()
    }

    void assertSampleSpecificOutcome(String dsl) {
    }

    void assertReversedFilesArePresentAndCorrect(String dsl) {
        assertReversedFileIsPresentAndCorrect(dsl, "hemingway") && assertReversedFileIsPresentAndCorrect(dsl, "steinbeck")
    }

    void assertReversedFileIsPresentAndCorrect(String dsl, String author) {
        def reversedFile = workerExecutorSample(dsl).file("build/reversed/${author}.txt")
        assert reversedFile.exists()
        assert reversedFile.readLines() == workerExecutorSample(dsl).file("sources/${author}.txt").readLines().collect { it.reverse() }
    }
}
