/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

@Internal
final class Zlib {
    Zlib() {
    }

    public static byte[] compress(byte[] data) {
        return Zlib.compress(data, 0, data.length);
    }

    public static byte[] compress(byte[] data, int start, int length) {
        return Zlib.deflate(data, start, length, false);
    }

    public static byte[] decompress(byte[] data, int off, int len) {
        return Zlib.inflate(data, off, len, false);
    }

    public static byte[] decompress(byte[] data) {
        return Zlib.decompress(data, 0, data.length);
    }

    public static void decompressToStream(byte[] data, int off, int len, Stream output, byte[] buffer) {
        InflaterOutputStream inflater = null;
        try {
            OutputStream outputStream = output.getOutputStream();
            inflater = new InflaterOutputStream(outputStream, new Inflater(false));
            inflater.write(data, off, len);
            inflater.close();
        }
        catch (IOException e) {
            AsposeUtils.safeClose(inflater);
        }
    }

    public static byte[] inflate(byte[] data) {
        return Zlib.inflate(data, 0, data.length, true);
    }

    private static byte[] inflate(byte[] data, int off, int len, boolean nowrap) {
        InflaterOutputStream out = null;
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            out = new InflaterOutputStream(tmp, new Inflater(nowrap));
            out.write(data, off, len);
            out.close();
            return tmp.toByteArray();
        }
        catch (IOException e) {
            AsposeUtils.safeClose(out);
            return null;
        }
    }

    public static byte[] deflate(byte[] data) {
        return Zlib.deflate(data, 0, data.length, true);
    }

    private static byte[] deflate(byte[] data, int start, int length, boolean nowrap) {
        DeflaterOutputStream out = null;
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            out = new DeflaterOutputStream((OutputStream)tmp, new Deflater(-1, nowrap));
            out.write(data, start, length);
            out.close();
            return tmp.toByteArray();
        }
        catch (IOException e) {
            AsposeUtils.safeClose(out);
            return null;
        }
    }
}

