/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;

class ValenceCache {
    private CornerTable table_;
    private byte[] vertex_valence_cache_8_bit_;
    private int[] vertex_valence_cache_32_bit_;

    public ValenceCache(CornerTable table) {
        this.table_ = table;
    }

    public byte valenceFromCacheInaccurateC(int c) {
        if (c == -1) {
            return -1;
        }
        return this.valenceFromCacheInaccurateV(this.table_.vertex(c));
    }

    public int valenceFromCacheC(int c) {
        if (c == -1) {
            return -1;
        }
        return this.valenceFromCacheV(this.table_.vertex(c));
    }

    public int confidentValenceFromCacheV(int v) {
        return this.vertex_valence_cache_32_bit_[v];
    }

    public void cacheValencesInaccurate() {
        if (this.vertex_valence_cache_8_bit_ == null) {
            int vertex_count = this.table_.getNumVertices();
            this.vertex_valence_cache_8_bit_ = new byte[vertex_count];
            for (int v = 0; v < vertex_count; ++v) {
                this.vertex_valence_cache_8_bit_[v] = (byte)Math.min(127, this.table_.valence(v));
            }
        }
    }

    public void cacheValences() {
        if (this.vertex_valence_cache_32_bit_ == null) {
            int vertex_count = this.table_.getNumVertices();
            this.vertex_valence_cache_32_bit_ = new int[vertex_count];
            for (int v = 0; v < vertex_count; ++v) {
                this.vertex_valence_cache_32_bit_[v] = this.table_.valence(v);
            }
        }
    }

    public byte confidentValenceFromCacheInaccurateC(int c) {
        return this.confidentValenceFromCacheInaccurateV(this.table_.confidentVertex(c));
    }

    public int confidentValenceFromCacheC(int c) {
        return this.confidentValenceFromCacheV(this.table_.confidentVertex(c));
    }

    public byte valenceFromCacheInaccurateV(int v) {
        if (v == -1 || v >= this.table_.getNumVertices()) {
            return -1;
        }
        return this.confidentValenceFromCacheInaccurateV(v);
    }

    public byte confidentValenceFromCacheInaccurateV(int v) {
        return this.vertex_valence_cache_8_bit_[v];
    }

    public int valenceFromCacheV(int v) {
        if (v == -1 || v >= this.table_.getNumVertices()) {
            return -1;
        }
        return this.confidentValenceFromCacheC(v);
    }

    public void clearValenceCacheInaccurate() {
        this.vertex_valence_cache_8_bit_ = null;
    }

    public void clearValenceCache() {
        this.vertex_valence_cache_32_bit_ = null;
    }

    public boolean isCacheEmpty() {
        return this.vertex_valence_cache_8_bit_ == null && this.vertex_valence_cache_32_bit_ == null;
    }
}

