/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeQuantizationTransform;
import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Dequantizer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.SequentialIntegerAttributeDecoder;

class SequentialQuantizationAttributeDecoder
extends SequentialIntegerAttributeDecoder {
    private int quantizationBits;
    private float[] minValue;
    private float maxValueDif;

    SequentialQuantizationAttributeDecoder() {
    }

    @Override
    public void initialize(PointCloudDecoder decoder, int attributeId) throws DrakoException {
        super.initialize(decoder, attributeId);
        PointAttribute attribute = decoder.getPointCloud().attribute(attributeId);
        if (attribute.getDataType() != 9) {
            throw DracoUtils.failed();
        }
    }

    @Override
    public void decodeIntegerValues(int[] pointIds, DecoderBuffer inBuffer) throws DrakoException {
        if (this.getDecoder().getBitstreamVersion() < 20) {
            this.decodeQuantizedDataInfo();
        }
        super.decodeIntegerValues(pointIds, inBuffer);
    }

    @Override
    protected void storeValues(int numValues) {
        this.dequantizeValues(numValues);
    }

    @Override
    public void decodeDataNeededByPortableTransform(int[] pointIds, DecoderBuffer in_buffer) throws DrakoException {
        if (this.getDecoder().getBitstreamVersion() >= 20) {
            this.decodeQuantizedDataInfo();
        }
        AttributeQuantizationTransform transform = new AttributeQuantizationTransform();
        transform.setParameters(this.quantizationBits, this.minValue, this.attribute.getComponentsCount(), this.maxValueDif);
        transform.transferToAttribute(this.getPortableAttribute());
    }

    private void decodeQuantizedDataInfo() throws DrakoException {
        int numComponents = this.getAttribute().getComponentsCount();
        this.minValue = new float[numComponents];
        if (!this.getDecoder().getBuffer().decode(this.minValue)) {
            throw DracoUtils.failed();
        }
        this.maxValueDif = this.decoder.getBuffer().decodeF32();
        byte quantizationBits = this.getDecoder().getBuffer().decodeU8();
        if ((0xFF & quantizationBits) > 31) {
            throw DracoUtils.failed();
        }
        this.quantizationBits = 0xFF & quantizationBits;
    }

    private void dequantizeValues(int numValues) {
        int maxQuantizedValue = (1 << this.quantizationBits) - 1;
        int numComponents = this.getAttribute().getComponentsCount();
        int entrySize = 4 * numComponents;
        float[] attVal = new float[numComponents];
        int quantValId = 0;
        int outBytePos = 0;
        Dequantizer dequantizer = new Dequantizer(this.maxValueDif, maxQuantizedValue);
        IntSpan values = ByteSpan.wrap(this.getPortableAttribute().getBuffer().getBuffer(), 0, numValues * numComponents * 4).asIntSpan();
        int i = 0;
        while ((0xFFFFFFFFL & (long)i) < (long)numValues) {
            for (int c = 0; c < numComponents; ++c) {
                float value = dequantizer.dequantizeFloat(values.get(quantValId++));
                attVal[c] = value += this.minValue[c];
            }
            this.getAttribute().getBuffer().write(outBytePos, attVal);
            outBytePos += entrySize;
            ++i;
        }
    }
}

