/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ByteSpan;
import dev.fileformat.drako.DracoEncodeOptions;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PredictionScheme;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.PredictionSchemeWrapTransform;
import dev.fileformat.drako.SequentialAttributeEncoder;

class SequentialIntegerAttributeEncoder
extends SequentialAttributeEncoder {
    private PredictionScheme predictionScheme;

    @Override
    public int getUniqueId() {
        return 1;
    }

    @Override
    public void initialize(PointCloudEncoder encoder, int attributeId) throws DrakoException {
        super.initialize(encoder, attributeId);
        if (this.getUniqueId() == 1 && !DracoUtils.isIntegerType(this.getAttribute().getDataType())) {
            throw DracoUtils.failed();
        }
        int predictionSchemeMethod = encoder.getOptions().getAttributePredictionScheme(this.getAttribute());
        this.predictionScheme = this.createIntPredictionScheme(predictionSchemeMethod);
        if (this.predictionScheme != null) {
            try {
                this.initPredictionScheme(this.predictionScheme);
            }
            catch (Exception $e) {
                this.predictionScheme = null;
            }
        }
    }

    @Override
    public void transformAttributeToPortableFormat(int[] point_ids) {
        if (this.getEncoder() != null) {
            this.prepareValues(point_ids, this.getEncoder().getPointCloud().getNumPoints());
        } else {
            this.prepareValues(point_ids, 0);
        }
        if (this.isParentEncoder()) {
            int i;
            PointAttribute orig_att = this.getAttribute();
            PointAttribute portable_att = this.portableAttribute;
            int[] value_to_value_map = new int[orig_att.getNumUniqueEntries()];
            for (i = 0; i < point_ids.length; ++i) {
                value_to_value_map[orig_att.mappedIndex((int)point_ids[i])] = i;
            }
            if (portable_att.getIdentityMapping()) {
                portable_att.setExplicitMapping(this.getEncoder().getPointCloud().getNumPoints());
            }
            for (i = 0; i < this.getEncoder().getPointCloud().getNumPoints(); ++i) {
                portable_att.setPointMapEntry(i, value_to_value_map[orig_att.mappedIndex(i)]);
            }
        }
    }

    @Override
    protected void encodeValues(int[] pointIds, EncoderBuffer outBuffer) throws DrakoException {
        PointAttribute attrib = this.getAttribute();
        if (attrib.getNumUniqueEntries() == 0) {
            return;
        }
        byte prediction_scheme_method = -2;
        if (this.predictionScheme != null) {
            this.setPredictionSchemeParentAttributes(this.predictionScheme);
            prediction_scheme_method = (byte)this.predictionScheme.getPredictionMethod();
        }
        outBuffer.encode(prediction_scheme_method);
        if (this.predictionScheme != null) {
            outBuffer.encode((byte)this.predictionScheme.getTransformType());
        }
        int num_components = this.portableAttribute.getComponentsCount();
        int num_values = num_components * this.portableAttribute.getNumUniqueEntries();
        IntSpan portable_attribute_data = this.getPortableAttributeData();
        IntSpan encoded_data = IntSpan.wrap(new int[num_values]);
        if (this.predictionScheme != null) {
            this.predictionScheme.computeCorrectionValues(portable_attribute_data, encoded_data, num_values, num_components, pointIds);
        }
        if (this.predictionScheme == null || !this.predictionScheme.areCorrectionsPositive()) {
            IntSpan input = this.predictionScheme != null ? encoded_data : portable_attribute_data;
            Encoding.convertSignedIntsToSymbols(input, num_values, encoded_data);
        }
        if (this.getEncoder() == null || this.getEncoder().getOptions().useBuiltinAttributeCompression) {
            outBuffer.encode((byte)1);
            DracoEncodeOptions symbol_encoding_options = new DracoEncodeOptions();
            if (this.getEncoder() != null) {
                symbol_encoding_options.setCompressionLevel(this.getEncoder().getOptions().getCompressionLevel());
            }
            Encoding.encodeSymbols(encoded_data, pointIds.length * num_components, num_components, symbol_encoding_options, outBuffer);
        } else {
            int masked_value = 0;
            for (int i = 0; i < num_values; ++i) {
                masked_value |= encoded_data.get(i);
            }
            int value_msb_pos = 0;
            if ((0xFFFFFFFFL & (long)masked_value) != 0L) {
                value_msb_pos = DracoUtils.mostSignificantBit(masked_value);
            }
            int num_bytes = 1 + value_msb_pos / 8;
            outBuffer.encode((byte)0);
            outBuffer.encode((byte)num_bytes);
            if (num_bytes == DracoUtils.dataTypeLength(5)) {
                outBuffer.encode(encoded_data, 4 * num_values);
            } else {
                for (int i = 0; i < num_values; ++i) {
                    outBuffer.encode(encoded_data, i * 4, num_bytes);
                }
            }
        }
        if (this.predictionScheme != null) {
            this.predictionScheme.encodePredictionData(outBuffer);
        }
    }

    private IntSpan getPortableAttributeData() {
        int num_components = this.portableAttribute.getComponentsCount();
        int num_values = num_components * this.portableAttribute.getNumUniqueEntries();
        byte[] buf = this.portableAttribute.getBuffer().getBuffer();
        return ByteSpan.wrap(buf, this.portableAttribute.getByteOffset(), num_values * 4).asIntSpan();
    }

    protected PredictionScheme createIntPredictionScheme(int method) {
        return PredictionScheme.create(this.getEncoder(), method, this.getAttributeId(), (PredictionSchemeTransform)new PredictionSchemeWrapTransform());
    }

    protected void prepareValues(int[] pointIds, int numPoints) {
        PointAttribute attrib = this.getAttribute();
        int numComponents = attrib.getComponentsCount();
        int numEntries = pointIds.length;
        int[] ref0 = new int[1];
        this.preparePortableAttribute(numEntries, numComponents, numPoints);
        int dstIndex = 0;
        IntSpan portable_attribute_data = this.getPortableAttributeData();
        for (int i = 0; i < numEntries; ++i) {
            int attId = attrib.mappedIndex(pointIds[i]);
            attrib.convertValue(attId, ref0);
            int tmp = ref0[0];
            portable_attribute_data.put(dstIndex, tmp);
            dstIndex += numComponents;
        }
    }

    private void preparePortableAttribute(int num_entries, int num_components, int num_points) {
        PointAttribute va = new PointAttribute();
        va.setAttributeType(this.attribute.getAttributeType());
        va.setComponentsCount(this.attribute.getComponentsCount());
        va.setDataType(5);
        va.setNormalized(false);
        va.setByteStride(num_components * DracoUtils.dataTypeLength(5));
        va.reset(num_entries);
        this.portableAttribute = va;
        if (num_points != 0) {
            this.portableAttribute.setExplicitMapping(num_points);
        }
    }
}

